/*
 * Decompiled with CFR 0.152.
 */
package java_cup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java_cup.ErrorManager;
import java_cup.action_part;
import java_cup.action_production;
import java_cup.lalr_state;
import java_cup.lookaheads;
import java_cup.lr_item;
import java_cup.non_terminal;
import java_cup.parse_action_table;
import java_cup.parse_reduce_table;
import java_cup.production;
import java_cup.production_part;
import java_cup.symbol;
import java_cup.symbol_part;
import java_cup.terminal;
import java_cup.terminal_set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grammar {
    private final ArrayList<terminal> _terminals;
    private final ArrayList<non_terminal> _nonterminals;
    private final ArrayList<production> _productions;
    private final ArrayList<production> _actions;
    private production _start_production;
    private final HashMap<Collection<lr_item>, lalr_state> _kernels_to_lalr = new HashMap();
    private final ArrayList<lalr_state> _lalr_states = new ArrayList();
    private int _num_conflicts = 0;
    private parse_action_table action_table;
    private parse_reduce_table reduce_table;
    private int next_nt = 0;

    public Grammar() {
        this._terminals = new ArrayList();
        this._nonterminals = new ArrayList();
        this._productions = new ArrayList();
        this._actions = new ArrayList();
        this._terminals.add(terminal.error);
        this._terminals.add(terminal.EOF);
        this._nonterminals.add(non_terminal.START_nt);
    }

    public non_terminal get_nonterminal(int i) {
        return this._nonterminals.get(i);
    }

    public terminal get_terminal(int i) {
        return this._terminals.get(i);
    }

    public production get_action(int i) {
        return this._actions.get(i);
    }

    public production get_production(int i) {
        return this._productions.get(i);
    }

    public production start_production() {
        return this._start_production;
    }

    public int num_terminals() {
        return this._terminals.size();
    }

    public int num_non_terminals() {
        return this._nonterminals.size();
    }

    public int num_productions() {
        return this._productions.size();
    }

    public int num_actions() {
        return this._actions.size();
    }

    public Iterable<terminal> terminals() {
        return this._terminals;
    }

    public Iterable<non_terminal> non_terminals() {
        return this._nonterminals;
    }

    public Iterable<production> productions() {
        return this._productions;
    }

    public Iterable<production> actions() {
        return this._actions;
    }

    public int num_conflicts() {
        return this._num_conflicts;
    }

    public terminal add_terminal(String name, String type) {
        terminal term = new terminal(name, type, this._terminals.size());
        this._terminals.add(term);
        return term;
    }

    public non_terminal add_non_terminal(String name, String type) {
        non_terminal nt = new non_terminal(name, type, this._nonterminals.size());
        this._nonterminals.add(nt);
        return nt;
    }

    public non_terminal star_symbol(symbol sym2) {
        if (sym2._star_symbol == null) {
            this.plus_symbol(sym2);
            String type = sym2._stack_type == null ? null : sym2._stack_type + "[]";
            sym2._star_symbol = this.add_non_terminal(sym2._name + "*", type);
        }
        return sym2._star_symbol;
    }

    public non_terminal plus_symbol(symbol sym2) {
        if (sym2._plus_symbol == null) {
            String type = sym2._stack_type == null ? null : sym2._stack_type + "[]";
            sym2._plus_symbol = this.add_non_terminal(sym2._name + "+", type);
        }
        return sym2._plus_symbol;
    }

    public non_terminal opt_symbol(symbol sym2) {
        if (sym2._opt_symbol == null) {
            sym2._opt_symbol = this.add_non_terminal(sym2._name + "?", sym2._stack_type);
        }
        return sym2._opt_symbol;
    }

    public void set_start_symbol(non_terminal start_nt) {
        String result;
        symbol_part[] rhs = new symbol_part[2];
        action_part action = null;
        if (start_nt.stack_type() != null) {
            rhs[0] = new symbol_part(start_nt, "CUP$rhs");
            result = "CUP$rhs";
        } else {
            rhs[0] = new symbol_part(start_nt);
            result = "null";
        }
        rhs[1] = new symbol_part(terminal.EOF);
        action = new action_part("RESULT = " + result + ";\n/* ACCEPT */\nparser.done_parsing();");
        this._start_production = new production(0, 0, non_terminal.START_nt, rhs, -1, action, null);
        this._productions.add(this._start_production);
        this._actions.add(this._start_production);
        non_terminal.START_nt.note_use();
    }

    private non_terminal create_anon_nonterm(String type) {
        return this.add_non_terminal("NT$" + this.next_nt++, type);
    }

    public production build_production(non_terminal lhs, List<production_part> rhs_parts, terminal precedence) {
        int i;
        if (this._start_production == null) {
            this.set_start_symbol(lhs);
        }
        assert (this._start_production != null);
        assert (lhs != null) : "Attempt to construct a production with a null LHS";
        lhs.note_use();
        if (precedence != null) {
            precedence.note_use();
        }
        Iterator<production_part> it = rhs_parts.iterator();
        action_part prev_action = null;
        while (it.hasNext()) {
            production_part part = it.next();
            if (part instanceof action_part) {
                if (prev_action != null) {
                    prev_action.add_code_string(((action_part)part).code_string());
                    it.remove();
                    continue;
                }
                prev_action = (action_part)part;
                continue;
            }
            prev_action = null;
        }
        action_part action = null;
        if (rhs_parts.size() > 0 && rhs_parts.get(rhs_parts.size() - 1) instanceof action_part) {
            action = (action_part)rhs_parts.remove(rhs_parts.size() - 1);
        }
        symbol_part[] rhs = new symbol_part[rhs_parts.size()];
        int last_act_loc = -1;
        for (i = 0; i < rhs.length; ++i) {
            production_part prod = rhs_parts.get(i);
            if (prod instanceof action_part) {
                non_terminal new_nt = this.create_anon_nonterm(lhs.stack_type());
                new_nt.note_use();
                rhs[i] = new symbol_part(new_nt);
                last_act_loc = i;
                continue;
            }
            rhs[i] = (symbol_part)prod;
        }
        int action_index = this._actions.size();
        if (rhs.length == 1 && action == null) {
            action_index = -1;
        }
        for (production prod : lhs.productions()) {
            if (!(action == null ? prod.action() == null : prod.action() != null && action.code_string().equals(prod.action().code_string())) || prod.rhs_length() != rhs.length || !this.productions_match(prod, rhs)) continue;
            action_index = prod.action_index();
            break;
        }
        production prod = new production(this._productions.size(), action_index, lhs, rhs, last_act_loc, action, precedence);
        this._productions.add(prod);
        if (action_index == this._actions.size()) {
            this._actions.add(prod);
        }
        last_act_loc = -1;
        for (i = 0; i < rhs.length; ++i) {
            production_part part = rhs_parts.get(i);
            if (!(part instanceof action_part)) continue;
            action_production actprod = new action_production(this._productions.size(), this._actions.size(), prod, (non_terminal)rhs[i].the_symbol, (action_part)part, i, last_act_loc);
            this._productions.add(actprod);
            this._actions.add(actprod);
            last_act_loc = i;
        }
        return prod;
    }

    private boolean productions_match(production prod, symbol_part[] rhs) {
        for (int idx = 0; idx < rhs.length; ++idx) {
            if (rhs[idx].label == null) {
                if (prod.rhs((int)idx).label == null) continue;
                return false;
            }
            if (!rhs[idx].label.equals(prod.rhs((int)idx).label)) {
                return false;
            }
            if (!(rhs[idx].the_symbol.stack_type() == null ? prod.rhs((int)idx).the_symbol.stack_type() != null : !rhs[idx].the_symbol.stack_type().equals(prod.rhs((int)idx).the_symbol.stack_type()))) continue;
            return false;
        }
        return true;
    }

    public lalr_state get_lalr_state(Map<lr_item, terminal_set> kernel) {
        Set<lr_item> key = kernel.keySet();
        lalr_state state = this._kernels_to_lalr.get(key);
        if (state != null) {
            state.propagate_lookaheads(kernel);
        } else {
            state = new lalr_state(kernel, this._lalr_states.size());
            this._lalr_states.add(state);
            this._kernels_to_lalr.put(key, state);
        }
        return state;
    }

    public Collection<lalr_state> lalr_states() {
        return this._lalr_states;
    }

    public void compute_nullability() {
        boolean change = true;
        while (change) {
            change = false;
            for (non_terminal nt : this._nonterminals) {
                change |= nt.check_nullable();
            }
        }
    }

    public void compute_first_sets() {
        boolean change = true;
        for (non_terminal nt : this._nonterminals) {
            nt._first_set = new terminal_set(this);
        }
        while (change) {
            change = false;
            for (non_terminal nt : this._nonterminals) {
                for (production prod : nt.productions()) {
                    terminal_set prod_first = prod.first_set(this);
                    change |= nt._first_set.add(prod_first);
                }
            }
        }
    }

    public lalr_state build_machine() {
        assert (this._start_production != null) : "Attempt to build viable prefix recognizer using a null production";
        TreeMap<lr_item, terminal_set> start_items = new TreeMap<lr_item, terminal_set>();
        terminal_set lookahead = new terminal_set(this);
        lookahead.add(terminal.EOF);
        lr_item core = this._start_production.item();
        start_items.put(core, lookahead);
        lalr_state start_state = this.get_lalr_state(start_items);
        for (int i = 0; i < this._lalr_states.size(); ++i) {
            lalr_state st = this._lalr_states.get(i);
            st.compute_closure(this);
            st.compute_successors(this);
        }
        return start_state;
    }

    public void dump_grammar() {
        System.err.println("===== Terminals =====");
        int cnt = 0;
        for (terminal t : this.terminals()) {
            System.err.print("[" + t.index() + "]" + t.name() + " ");
            if (++cnt % 5 != 0) continue;
            System.err.println();
        }
        System.err.println();
        System.err.println();
        System.err.println("===== Non terminals =====");
        cnt = 0;
        for (non_terminal nt : this.non_terminals()) {
            System.err.print("[" + nt.index() + "]" + nt.name() + " ");
            if (++cnt % 5 != 0) continue;
            System.err.println();
        }
        System.err.println();
        System.err.println();
        System.err.println("===== Productions =====");
        for (production prod : this.productions()) {
            System.err.println("[" + prod.index() + "] " + prod);
        }
        System.err.println();
    }

    public void dump_machine() {
        System.err.println("===== Viable Prefix Recognizer =====");
        for (lalr_state st : this.lalr_states()) {
            System.err.println(st);
            System.err.println("-------------------");
        }
    }

    public void dump_tables() {
        System.err.println(this.action_table);
        System.err.println(this.reduce_table);
    }

    public void report_reduce_reduce(lalr_state state, Map.Entry<lr_item, lookaheads> itm1, Map.Entry<lr_item, lookaheads> itm2) {
        StringBuilder message = new StringBuilder();
        message.append("*** Reduce/Reduce conflict found in state #").append(state.index()).append("\n").append("  between ").append(itm1.getKey().toString()).append("\n").append("  and     ").append(itm2.getKey().toString()).append("\n").append("  under symbols: {");
        String comma = "";
        for (int t = 0; t < this.num_terminals(); ++t) {
            if (!itm1.getValue().contains(t) || !itm2.getValue().contains(t)) continue;
            message.append(comma).append(this.get_terminal(t).name());
            comma = ", ";
        }
        message.append("}\n  Resolved in favor of the first production.\n");
        ++this._num_conflicts;
        ErrorManager.getManager().emit_warning(message.toString());
    }

    public void report_shift_reduce(lalr_state state, production p, symbol conflict_sym) {
        StringBuilder message = new StringBuilder();
        message.append("*** Shift/Reduce conflict found in state #").append(state.index()).append("\n");
        message.append("  between ").append(p).append("(*)\n");
        for (lr_item itm : state.items().keySet()) {
            if (itm.dot_at_end() || !itm.symbol_after_dot().equals(conflict_sym)) continue;
            message.append("  and     ").append(itm).append("\n");
        }
        message.append("  under symbol ").append(conflict_sym).append("\n");
        message.append("  Resolved in favor of shifting.\n");
        ++this._num_conflicts;
        ErrorManager.getManager().emit_warning(message.toString());
    }

    public void build_tables(boolean compact_reduces) {
        this.action_table = new parse_action_table(this);
        this.reduce_table = new parse_reduce_table(this);
        for (lalr_state lst : this.lalr_states()) {
            lst.build_table_entries(this, this.action_table, this.reduce_table, compact_reduces);
        }
    }

    public void check_tables() {
        boolean[] used_productions = new boolean[this._productions.size()];
        for (int row = 0; row < this.lalr_states().size(); ++row) {
            for (int col = 0; col < this.num_terminals(); ++col) {
                int act = this.action_table.table[row][col];
                if (!parse_action_table.isReduce(act)) continue;
                used_productions[parse_action_table.index((int)act)] = true;
            }
        }
        for (production prod : this.actions()) {
            if (used_productions[prod.action_index()]) continue;
            ErrorManager.getManager().emit_warning("*** Production \"" + prod.toString() + "\" never reduced");
        }
    }

    public parse_action_table action_table() {
        return this.action_table;
    }

    public parse_reduce_table reduce_table() {
        return this.reduce_table;
    }

    public void add_star_production(non_terminal lhs, non_terminal sym_star, symbol sym2) {
        ArrayList<production_part> rhs = new ArrayList<production_part>(2);
        rhs.add(new symbol_part(sym_star));
        rhs.add(new symbol_part(sym2));
        if (sym2.stack_type() != null) {
            rhs.add(new action_part("CUP$STAR2"));
        }
        this.build_production(lhs, rhs, null);
    }

    public void add_wildcard_rules(symbol sym2) {
        ArrayList<production_part> rhs;
        if (sym2._opt_symbol != null) {
            rhs = new ArrayList<production_part>(1);
            if (sym2.stack_type() != null) {
                rhs.add(new action_part("RESULT=null;"));
            }
            this.build_production(sym2._opt_symbol, rhs, null);
            rhs = new ArrayList(1);
            rhs.add(new symbol_part(sym2));
            this.build_production(sym2._opt_symbol, rhs, null);
        }
        if (sym2._star_symbol != null) {
            assert (sym2._plus_symbol != null);
            rhs = new ArrayList(1);
            if (sym2.stack_type() != null) {
                rhs.add(new action_part("CUP$STAR0"));
            }
            this.build_production(sym2._star_symbol, rhs, null);
            rhs = new ArrayList(1);
            rhs.add(new symbol_part(sym2._plus_symbol));
            this.build_production(sym2._star_symbol, rhs, null);
        }
        if (sym2._plus_symbol != null) {
            rhs = new ArrayList(1);
            rhs.add(new symbol_part(sym2));
            if (sym2.stack_type() != null) {
                rhs.add(new action_part("CUP$STAR1"));
            }
            this.build_production(sym2._plus_symbol, rhs, null);
            this.add_star_production(sym2._plus_symbol, sym2._plus_symbol, sym2);
        }
    }

    public void add_wildcard_rules() {
        for (terminal terminal2 : this.terminals()) {
            this.add_wildcard_rules(terminal2);
        }
        for (non_terminal non_terminal2 : this.non_terminals()) {
            this.add_wildcard_rules(non_terminal2);
        }
    }
}

