/*
 * Decompiled with CFR 0.152.
 */
package java_cup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java_cup.ErrorManager;
import java_cup.Grammar;
import java_cup.Lexer;
import java_cup.emit;
import java_cup.non_terminal;
import java_cup.parser;
import java_cup.runtime.ComplexSymbolFactory;
import java_cup.terminal;

public class Main {
    private boolean print_progress = false;
    private boolean opt_dump_states = false;
    private boolean opt_dump_tables = false;
    private boolean opt_dump_grammar = false;
    private boolean opt_show_timing = false;
    private boolean opt_do_debug = false;
    private boolean opt_compact_red = false;
    private boolean opt_java15 = false;
    private boolean include_non_terms = false;
    private boolean no_summary = false;
    private int expect_conflicts = 0;
    private boolean opt_lr_values = true;
    private boolean opt_old_lr_values = true;
    private boolean sym_interface = false;
    private boolean suppress_scanner = false;
    private long start_time = 0L;
    private long prelim_end = 0L;
    private long parse_end = 0L;
    private long check_end = 0L;
    private long dump_end = 0L;
    private long build_end = 0L;
    private long nullability_end = 0L;
    private long first_end = 0L;
    private long machine_end = 0L;
    private long table_end = 0L;
    private long reduce_check_end = 0L;
    private long emit_end = 0L;
    private long final_time = 0L;
    emit emit = new emit();
    private InputStream input_file = System.in;
    private PrintWriter parser_class_file;
    private PrintWriter symbol_class_file;
    private File dest_dir = null;

    public Main() {
        this.start_time = System.currentTimeMillis();
    }

    public boolean run() throws Exception {
        boolean did_output = false;
        this.prelim_end = System.currentTimeMillis();
        if (this.print_progress) {
            System.err.println("Parsing specification...");
        }
        Grammar grammar = this.parse_grammar_spec();
        grammar.add_wildcard_rules();
        this.parse_end = System.currentTimeMillis();
        if (ErrorManager.getManager().getErrorCount() == 0) {
            if (this.print_progress) {
                System.err.println("Checking specification...");
            }
            this.check_unused(grammar);
            this.check_end = System.currentTimeMillis();
            if (this.print_progress) {
                System.err.println("Building parse tables...");
            }
            this.build_parser(grammar);
            this.build_end = System.currentTimeMillis();
            if (ErrorManager.getManager().getErrorCount() != 0) {
                this.opt_dump_tables = false;
            } else {
                if (this.print_progress) {
                    System.err.println("Writing parser...");
                }
                this.open_files();
                this.emit_parser(grammar);
                did_output = true;
                if (this.print_progress) {
                    System.err.println("Closing files...");
                }
                this.close_files();
            }
        }
        this.emit_end = System.currentTimeMillis();
        if (this.opt_dump_grammar) {
            grammar.dump_grammar();
        }
        if (this.opt_dump_states) {
            grammar.dump_machine();
        }
        if (this.opt_dump_tables) {
            grammar.dump_tables();
        }
        this.dump_end = System.currentTimeMillis();
        if (!this.no_summary) {
            this.emit_summary(grammar, did_output);
        }
        return ErrorManager.getManager().getErrorCount() == 0;
    }

    private void usage() {
        System.err.println();
        System.err.println("Usage: java_cup [options] [filename]\n  and expects a specification file on standard input if no filename is given.\n  Legal options include:\n    -package name  specify package generated classes go in [default none]\n    -destdir name  specify the destination directory, to store the generated files in\n    -parser name   specify parser class name [default \"parser\"]\n    -typearg args  specify type arguments for parser class\n    -symbols name  specify name for symbol constant class [default \"sym\"]\n    -interface     put symbols in an interface, rather than a class\n    -nonterms      put non terminals in symbol constant class\n    -expect #      number of conflicts expected/allowed [default 0]\n    -compact_red   compact tables by defaulting to most frequent reduce\n    -newpositions  don't generate old style access for left and right token\n    -nowarn        don't warn about useless productions, etc.\n    -nosummary     don't print the usual summary of parse states, etc.\n    -nopositions   don't propagate the left and right token position values\n    -noscanner     don't refer to java_cup.runtime.Scanner\n    -progress      print messages to indicate progress of the system\n    -time          print time usage summary\n    -dump_grammar  produce a human readable dump of the symbols and grammar\n    -dump_states   produce a dump of parse state machine\n    -dump_tables   produce a dump of the parse tables\n    -dump          produce a dump of all of the above\n    -version       print the version information for CUP and exit\n");
        System.exit(1);
    }

    public boolean setOption(String option) {
        return this.setOption(option, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setOption(String option, String arg) {
        if (option.equals("package")) {
            if (arg != null) {
                this.emit.package_name = arg;
                return true;
            }
            System.err.println("package must have a name argument");
            return false;
        }
        if (option.equals("destdir")) {
            if (arg != null) {
                this.dest_dir = new File(arg);
                return true;
            }
            System.err.println("destdir must have a name argument");
            return false;
        }
        if (option.equals("parser")) {
            if (arg != null) {
                this.emit.parser_class_name = arg;
                return true;
            }
            System.err.println("parser must have a name argument");
            return false;
        }
        if (option.equals("typearg")) {
            if (arg == null) {
                System.err.println("symbols must have a name argument");
                return false;
            }
            this.opt_java15 = true;
            this.emit.class_type_argument = option;
            return true;
        }
        if (option.equals("symbols")) {
            if (arg != null) {
                this.emit.symbol_const_class_name = arg;
                return true;
            }
            System.err.println("symbols must have a name argument");
            return false;
        }
        if (option.equals("nonterms")) {
            this.include_non_terms = true;
            return true;
        }
        if (option.equals("expect")) {
            if (arg == null) {
                System.err.println("expect must have a number argument");
                return false;
            }
            try {
                this.expect_conflicts = Integer.parseInt(arg);
                return true;
            }
            catch (NumberFormatException e) {
                System.err.println("expect must be followed by a decimal integer");
                return false;
            }
        }
        if (option.equals("java15")) {
            this.opt_java15 = true;
            return true;
        }
        if (option.equals("compact_red")) {
            this.opt_compact_red = true;
            return true;
        }
        if (option.equals("nosummary")) {
            this.no_summary = true;
            return true;
        }
        if (option.equals("nowarn")) {
            this.emit.nowarn = true;
            return true;
        }
        if (option.equals("dump_states")) {
            this.opt_dump_states = true;
            return true;
        }
        if (option.equals("dump_tables")) {
            this.opt_dump_tables = true;
            return true;
        }
        if (option.equals("progress")) {
            this.print_progress = true;
            return true;
        }
        if (option.equals("dump_grammar")) {
            this.opt_dump_grammar = true;
            return true;
        }
        if (option.equals("dump")) {
            this.opt_dump_grammar = true;
            this.opt_dump_tables = true;
            this.opt_dump_states = true;
            return true;
        }
        if (option.equals("time")) {
            this.opt_show_timing = true;
            return true;
        }
        if (option.equals("debug")) {
            this.opt_do_debug = true;
            return true;
        }
        if (option.equals("nopositions")) {
            this.opt_lr_values = false;
            this.opt_old_lr_values = false;
            return true;
        }
        if (option.equals("newpositions")) {
            this.opt_old_lr_values = false;
            return true;
        }
        if (option.equals("interface")) {
            this.sym_interface = true;
            return true;
        }
        if (option.equals("noscanner")) {
            this.suppress_scanner = true;
            return true;
        }
        System.err.println("Unrecognized option \"" + option + "\"");
        return false;
    }

    private void parse_args(String[] argv) {
        int len = argv.length;
        for (int i = 0; i < len; ++i) {
            String option = argv[i];
            if (option.equals("-package") || option.equals("-destdir") || option.equals("-parser") || option.equals("-typearg") || option.equals("-symbols") || option.equals("-expect")) {
                if (++i >= len || argv[i].startsWith("-") || argv[i].endsWith(".cup")) {
                    System.err.println(option + " must have an argument");
                    continue;
                }
                if (this.setOption(option.substring(1), argv[i])) continue;
                this.usage();
                continue;
            }
            if (argv[i].equals("-version")) {
                System.out.println("CUP v0.12joho 20110608");
                System.exit(1);
                continue;
            }
            if (option.startsWith("-")) {
                if (this.setOption(option.substring(1))) continue;
                this.usage();
                continue;
            }
            if (!argv[i].startsWith("-") && i == len - 1) {
                try {
                    this.input_file = new FileInputStream(argv[i]);
                }
                catch (FileNotFoundException e) {
                    System.err.println("Unable to open \"" + argv[i] + "\" for input");
                    this.usage();
                }
                continue;
            }
            System.err.println("Unrecognized option \"" + argv[i] + "\"");
            this.usage();
        }
    }

    private void open_files() {
        String out_name = this.emit.parser_class_name + ".java";
        File fil = new File(this.dest_dir, out_name);
        try {
            this.parser_class_file = new PrintWriter(new BufferedOutputStream(new FileOutputStream(fil), 4096));
        }
        catch (Exception e) {
            System.err.println("Can't open \"" + out_name + "\" for output");
            System.exit(3);
        }
        out_name = this.emit.symbol_const_class_name + ".java";
        fil = new File(this.dest_dir, out_name);
        try {
            this.symbol_class_file = new PrintWriter(new BufferedOutputStream(new FileOutputStream(fil), 4096));
        }
        catch (Exception e) {
            System.err.println("Can't open \"" + out_name + "\" for output");
            System.exit(4);
        }
    }

    private void close_files() throws IOException {
        if (this.parser_class_file != null) {
            this.parser_class_file.close();
        }
        if (this.symbol_class_file != null) {
            this.symbol_class_file.close();
        }
    }

    private Grammar parse_grammar_spec() {
        ComplexSymbolFactory csf = new ComplexSymbolFactory();
        parser parser_obj = new parser(new Lexer(this.input_file, csf), csf);
        parser_obj.main = this;
        parser_obj.emit = this.emit;
        try {
            Grammar grammar = this.opt_do_debug ? (Grammar)parser_obj.debug_parse().value : (Grammar)parser_obj.parse().value;
            if (this.input_file != System.in) {
                this.input_file.close();
            }
            return grammar;
        }
        catch (Exception e) {
            AssertionError error = new AssertionError((Object)"Exception in parser");
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
    }

    private void check_unused(Grammar grammar) {
        for (terminal term : grammar.terminals()) {
            if (term == terminal.EOF || term == terminal.error || term.use_count() != 0) continue;
            ++this.emit.unused_term;
            if (this.emit.nowarn) continue;
            ErrorManager.getManager().emit_warning("Terminal \"" + term.name() + "\" was declared but never used");
        }
        for (non_terminal nt : grammar.non_terminals()) {
            if (nt.use_count() != 0 && nt.productions().size() != 0) continue;
            ++this.emit.unused_non_term;
            if (this.emit.nowarn) continue;
            String reason = nt.use_count() == 0 ? "\" was declared but never used" : "\" has no production";
            ErrorManager.getManager().emit_warning("Non terminal \"" + nt.name() + reason);
        }
    }

    private void build_parser(Grammar grammar) {
        if (this.opt_do_debug || this.print_progress) {
            System.err.println("  Computing non-terminal nullability...");
        }
        grammar.compute_nullability();
        this.nullability_end = System.currentTimeMillis();
        if (this.opt_do_debug || this.print_progress) {
            System.err.println("  Computing first sets...");
        }
        grammar.compute_first_sets();
        this.first_end = System.currentTimeMillis();
        if (this.opt_do_debug || this.print_progress) {
            System.err.println("  Building state machine...");
        }
        grammar.build_machine();
        this.machine_end = System.currentTimeMillis();
        if (this.opt_do_debug || this.print_progress) {
            System.err.println("  Filling in tables...");
        }
        grammar.build_tables(this.opt_compact_red);
        this.table_end = System.currentTimeMillis();
        if (this.opt_do_debug || this.print_progress) {
            System.err.println("  Checking for non-reduced productions...");
        }
        if (!this.emit.nowarn) {
            grammar.check_tables();
        }
        this.reduce_check_end = System.currentTimeMillis();
        if (grammar.num_conflicts() > this.expect_conflicts) {
            ErrorManager.getManager().emit_error("*** More conflicts encountered than expected -- parser generation aborted");
        }
    }

    private void emit_parser(Grammar grammar) {
        this.emit.symbols(this.symbol_class_file, grammar, this.include_non_terms, this.sym_interface);
        this.emit.parser(this.parser_class_file, grammar, this.suppress_scanner, this.opt_lr_values, this.opt_old_lr_values, this.opt_java15);
    }

    private String plural(int val) {
        if (val == 1) {
            return "";
        }
        return "s";
    }

    private void emit_summary(Grammar grammar, boolean output_produced) {
        this.final_time = System.currentTimeMillis();
        System.err.println("------- CUP v0.12joho 20110608 Parser Generation Summary -------");
        System.err.println("  " + ErrorManager.getManager().getErrorCount() + " error" + this.plural(ErrorManager.getManager().getErrorCount()) + " and " + ErrorManager.getManager().getWarningCount() + " warning" + this.plural(ErrorManager.getManager().getWarningCount()));
        System.err.print("  " + grammar.num_terminals() + " terminal" + this.plural(grammar.num_terminals()) + ", ");
        System.err.print(grammar.num_non_terminals() + " non-terminal" + this.plural(grammar.num_non_terminals()) + ", and ");
        System.err.println(grammar.num_productions() + " production" + this.plural(grammar.num_productions()) + " declared, ");
        System.err.print("  producing " + grammar.lalr_states().size() + " unique parse states,");
        System.err.println(" " + grammar.num_actions() + " unique action" + this.plural(grammar.num_actions()) + ". ");
        System.err.println("  " + this.emit.unused_term + " terminal" + this.plural(this.emit.unused_term) + " declared but not used.");
        System.err.println("  " + this.emit.unused_non_term + " non-terminal" + this.plural(this.emit.unused_non_term) + " declared but not used.");
        System.err.println("  " + this.emit.not_reduced + " production" + this.plural(this.emit.not_reduced) + " never reduced.");
        System.err.println("  " + grammar.num_conflicts() + " conflict" + this.plural(grammar.num_conflicts()) + " detected" + " (" + this.expect_conflicts + " expected).");
        if (output_produced) {
            System.err.println("  Code written to \"" + this.emit.parser_class_name + ".java\", and \"" + this.emit.symbol_const_class_name + ".java\".");
        } else {
            System.err.println("  No code produced.");
        }
        if (this.opt_show_timing) {
            this.show_times();
        }
        System.err.println("---------------------------------------------------- (v0.12joho 20110608)");
    }

    private void show_times() {
        long total_time = this.final_time - this.start_time;
        System.err.println(". . . . . . . . . . . . . . . . . . . . . . . . . ");
        System.err.println("  Timing Summary");
        System.err.println("    Total time       " + this.timestr(this.final_time - this.start_time, total_time));
        System.err.println("      Startup        " + this.timestr(this.prelim_end - this.start_time, total_time));
        System.err.println("      Parse          " + this.timestr(this.parse_end - this.prelim_end, total_time));
        if (this.check_end != 0L) {
            System.err.println("      Checking       " + this.timestr(this.check_end - this.parse_end, total_time));
        }
        if (this.check_end != 0L && this.build_end != 0L) {
            System.err.println("      Parser Build   " + this.timestr(this.build_end - this.check_end, total_time));
        }
        if (this.nullability_end != 0L && this.check_end != 0L) {
            System.err.println("        Nullability  " + this.timestr(this.nullability_end - this.check_end, total_time));
        }
        if (this.first_end != 0L && this.nullability_end != 0L) {
            System.err.println("        First sets   " + this.timestr(this.first_end - this.nullability_end, total_time));
        }
        if (this.machine_end != 0L && this.first_end != 0L) {
            System.err.println("        State build  " + this.timestr(this.machine_end - this.first_end, total_time));
        }
        if (this.table_end != 0L && this.machine_end != 0L) {
            System.err.println("        Table build  " + this.timestr(this.table_end - this.machine_end, total_time));
        }
        if (this.reduce_check_end != 0L && this.table_end != 0L) {
            System.err.println("        Checking     " + this.timestr(this.reduce_check_end - this.table_end, total_time));
        }
        if (this.emit_end != 0L && this.build_end != 0L) {
            System.err.println("      Code Output    " + this.timestr(this.emit_end - this.build_end, total_time));
        }
        if (this.emit.symbols_time != 0L) {
            System.err.println("        Symbols      " + this.timestr(this.emit.symbols_time, total_time));
        }
        if (this.emit.parser_time != 0L) {
            System.err.println("        Parser class " + this.timestr(this.emit.parser_time, total_time));
        }
        if (this.emit.action_code_time != 0L) {
            System.err.println("          Actions    " + this.timestr(this.emit.action_code_time, total_time));
        }
        if (this.emit.production_table_time != 0L) {
            System.err.println("          Prod table " + this.timestr(this.emit.production_table_time, total_time));
        }
        if (this.emit.action_table_time != 0L) {
            System.err.println("          Action tab " + this.timestr(this.emit.action_table_time, total_time));
        }
        if (this.emit.goto_table_time != 0L) {
            System.err.println("          Reduce tab " + this.timestr(this.emit.goto_table_time, total_time));
        }
        System.err.println("      Dump Output    " + this.timestr(this.dump_end - this.emit_end, total_time));
    }

    private String timestr(long time_val, long total_time) {
        String sec = "   " + time_val / 1000L;
        String ms = "00" + time_val % 1000L;
        long percent10 = time_val * 1000L / total_time;
        return sec.substring(sec.length() - 4) + "." + ms.substring(ms.length() - 3) + "sec" + " (" + percent10 / 10L + "." + percent10 % 10L + "%)";
    }

    public static void main(String[] argv) throws Exception {
        Main main = new Main();
        main.parse_args(argv);
        boolean success = main.run();
        if (!success) {
            System.exit(1);
        }
    }
}

