/*
 * Decompiled with CFR 0.152.
 */
package java_cup;

import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java_cup.Grammar;
import java_cup.lalr_transition;
import java_cup.lookaheads;
import java_cup.lr_item;
import java_cup.non_terminal;
import java_cup.parse_action_table;
import java_cup.parse_reduce_table;
import java_cup.production;
import java_cup.symbol;
import java_cup.terminal;
import java_cup.terminal_set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class lalr_state {
    private TreeMap<lr_item, lookaheads> _items;
    private lalr_transition _transitions = null;
    private int _index;

    public lalr_state(Map<lr_item, terminal_set> kernel, int index) {
        if (kernel == null) {
            throw new AssertionError((Object)"Attempt to construct an LALR state from a null item set");
        }
        this._index = index;
        this._items = new TreeMap();
        for (Map.Entry<lr_item, terminal_set> entry : kernel.entrySet()) {
            this._items.put(entry.getKey(), new lookaheads(entry.getValue()));
        }
    }

    public TreeMap<lr_item, lookaheads> items() {
        return this._items;
    }

    public int index() {
        return this._index;
    }

    public void compute_closure(Grammar grammar) {
        Stack<lr_item> consider = new Stack<lr_item>();
        consider.addAll(this._items.keySet());
        while (consider.size() > 0) {
            lr_item itm = (lr_item)consider.pop();
            non_terminal nt = itm.dot_before_nt();
            if (nt == null) continue;
            lr_item nextitm = itm.shift_item();
            terminal_set new_lookaheads = nextitm.calc_lookahead(grammar);
            boolean need_prop = nextitm.is_nullable();
            if (need_prop) {
                new_lookaheads.add(this._items.get(itm));
            }
            for (production prod : nt.productions()) {
                lookaheads new_la;
                lr_item new_itm = prod.item();
                if (this._items.containsKey(new_itm)) {
                    new_la = this._items.get(new_itm);
                    new_la.add(new_lookaheads);
                } else {
                    new_la = new lookaheads(new_lookaheads);
                    this._items.put(new_itm, new_la);
                    consider.push(new_itm);
                }
                if (!need_prop) continue;
                this._items.get(itm).add_listener(new_la);
            }
        }
    }

    public void compute_successors(Grammar grammar) {
        TreeMap outgoing = new TreeMap();
        for (lr_item itm : this._items.keySet()) {
            symbol sym2 = itm.symbol_after_dot();
            if (sym2 == null) continue;
            if (!outgoing.containsKey(sym2)) {
                outgoing.put(sym2, new ArrayList());
            }
            ((ArrayList)outgoing.get(sym2)).add(itm);
        }
        for (symbol out : outgoing.keySet()) {
            TreeMap<lr_item, terminal_set> new_items = new TreeMap<lr_item, terminal_set>();
            ArrayList<symbol> proxy_symbols = new ArrayList<symbol>();
            proxy_symbols.add(out);
            for (int i = 0; i < proxy_symbols.size(); ++i) {
                symbol sym3 = (symbol)proxy_symbols.get(i);
                for (lr_item itm : (ArrayList)outgoing.get(sym3)) {
                    if (itm.the_production.is_proxy()) {
                        non_terminal proxy = itm.the_production.lhs();
                        if (proxy_symbols.contains(proxy)) continue;
                        proxy_symbols.add(proxy);
                        continue;
                    }
                    new_items.put(itm.shift_item(), this.items().get(itm));
                }
            }
            lalr_state new_st = grammar.get_lalr_state(new_items);
            for (symbol sym4 : proxy_symbols) {
                for (lr_item itm : (ArrayList)outgoing.get(sym4)) {
                    if (itm.the_production.is_proxy()) continue;
                    this.items().get(itm).add_listener(new_st.items().get(itm.shift_item()));
                }
            }
            this._transitions = new lalr_transition(out, new_st, this._transitions);
        }
    }

    public void propagate_lookaheads(Map<lr_item, terminal_set> new_kernel) {
        for (Map.Entry<lr_item, terminal_set> entry : new_kernel.entrySet()) {
            this._items.get(entry.getKey()).add(entry.getValue());
        }
    }

    public void build_table_entries(Grammar grammar, parse_action_table act_table, parse_reduce_table reduce_table, boolean compact_reduces) {
        int act;
        int default_lasize = 0;
        int default_action = 0;
        boolean default_prodisempty = false;
        int[] our_act_row = act_table.table[this.index()];
        production[] productions = new production[grammar.num_terminals() + 1];
        lalr_state[] our_red_row = reduce_table.table[this.index()];
        for (Map.Entry<lr_item, lookaheads> itm : this.items().entrySet()) {
            production prod;
            if (!itm.getKey().dot_at_end()) continue;
            boolean conflict = false;
            act = parse_action_table.action(2, itm.getKey().the_production.action_index());
            int lasize = 0;
            for (int t = 0; t < grammar.num_terminals(); ++t) {
                if (!itm.getValue().contains(t)) continue;
                ++lasize;
                if (our_act_row[t] == 0) {
                    our_act_row[t] = act;
                    productions[t] = itm.getKey().the_production;
                    continue;
                }
                conflict = true;
            }
            if (conflict) {
                for (Map.Entry<lr_item, lookaheads> compare : this.items().entrySet()) {
                    if (itm.getKey() == compare.getKey()) break;
                    if (!compare.getKey().dot_at_end() || !compare.getValue().intersects(itm.getValue())) continue;
                    grammar.report_reduce_reduce(this, compare, itm);
                }
            }
            if (!compact_reduces || lasize <= default_lasize || (prod = itm.getKey().the_production).rhs_length() == 0 && lasize <= 1) continue;
            default_prodisempty = prod.rhs_length() == 0;
            default_lasize = lasize;
            default_action = act;
        }
        lalr_transition trans = this._transitions;
        while (trans != null) {
            symbol sym2 = trans.on_symbol;
            int idx = sym2.index();
            if (!sym2.is_non_term()) {
                act = parse_action_table.action(1, trans.to_state.index());
                if (our_act_row[idx] == 0) {
                    our_act_row[sym2.index()] = act;
                } else {
                    production p = productions[idx];
                    if (!this.fix_with_precedence(p, (terminal)sym2, our_act_row, act)) {
                        our_act_row[idx] = act;
                        grammar.report_shift_reduce(this, p, sym2);
                    }
                }
            } else {
                our_red_row[idx] = trans.to_state;
            }
            trans = trans.next;
        }
        act = our_act_row[terminal.error.index()];
        if (act != 0) {
            default_action = parse_action_table.isReduce(act) ? act : 0;
            default_prodisempty = false;
        }
        our_act_row[grammar.num_terminals()] = default_action;
        if (default_action != 0) {
            for (int i = 0; i < grammar.num_terminals(); ++i) {
                if (our_act_row[i] != 0 || i == terminal.error.index() && default_prodisempty) continue;
                our_act_row[i] = default_action;
            }
        }
    }

    private boolean fix_with_precedence(production p, terminal term, int[] table_row, int shift_act) {
        if (p.precedence_num() > -1 && term.precedence_num() > -1) {
            int compare = term.precedence_num() - p.precedence_num();
            if (compare == 0) {
                compare = term.precedence_side() - 1;
            }
            if (compare < 0) {
                return true;
            }
            if (compare > 0) {
                table_row[term.index()] = shift_act;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("lalr_state [").append(this.index()).append("]: {\n");
        for (Map.Entry<lr_item, lookaheads> itm : this.items().entrySet()) {
            if (itm.getKey().dot_pos == 0) continue;
            result.append("  [").append(itm.getKey()).append(", ");
            result.append(itm.getValue()).append("]\n");
        }
        for (Map.Entry<lr_item, lookaheads> itm : this.items().entrySet()) {
            if (itm.getKey().dot_pos != 0) continue;
            result.append("  [").append(itm.getKey()).append(", ");
            result.append(itm.getValue()).append("]\n");
        }
        result.append("}\n");
        lalr_transition tr = this._transitions;
        while (tr != null) {
            result.append(tr).append("\n");
            tr = tr.next;
        }
        return result.toString();
    }
}

