/*
 * Decompiled with CFR 0.152.
 */
package JFlex.gui;

import JFlex.Out;
import JFlex.gui.GeneratorThread;
import JFlex.gui.GridPanel;
import JFlex.gui.Handles;
import JFlex.gui.OptionsDialog;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

public final class MainFrame
extends Frame
implements Handles {
    private volatile boolean choosing;
    private String fileName = "";
    private String dirName = "";
    private Button quit;
    private Button options;
    private Button generate;
    private Button stop;
    private Button specChoose;
    private Button dirChoose;
    private TextField spec;
    private TextField dir;
    private TextArea messages;
    private GeneratorThread thread;
    private OptionsDialog dialog;

    public MainFrame() {
        super("JFlex 1.4.2");
        this.buildContent();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainFrame.this.quit();
            }
        });
        this.pack();
        this.show();
    }

    private void buildContent() {
        ((Component)this).setBackground(SystemColor.control);
        this.generate = new Button("Generate");
        this.quit = new Button("Quit");
        this.options = new Button("Options");
        this.stop = new Button("Stop");
        this.dirChoose = new Button("Browse");
        this.dir = new TextField(10);
        this.specChoose = new Button("Browse");
        this.spec = new TextField(10);
        this.messages = new TextArea(10, 80);
        this.messages.setEditable(false);
        Font font = this.messages.getFont();
        if (font != null) {
            this.messages.setFont(new Font("Monospaced", font.getStyle(), font.getSize()));
        } else {
            this.messages.setFont(new Font("Monospaced", 0, 12));
        }
        Out.setGUIMode(this.messages);
        this.generate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.generate();
            }
        });
        this.options.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.showOptions();
            }
        });
        this.quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.quit();
            }
        });
        this.stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.stop();
            }
        });
        this.specChoose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.specChoose();
            }
        });
        this.dirChoose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.dirChoose();
            }
        });
        this.spec.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.fileName = MainFrame.this.spec.getText();
                MainFrame.this.generate();
            }
        });
        this.spec.addTextListener(new TextListener(){

            public void textValueChanged(TextEvent e) {
                MainFrame.this.fileName = MainFrame.this.spec.getText();
            }
        });
        this.dir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.dirName = MainFrame.this.dir.getText();
                MainFrame.this.generate();
            }
        });
        this.dir.addTextListener(new TextListener(){

            public void textValueChanged(TextEvent e) {
                MainFrame.this.dirName = MainFrame.this.dir.getText();
            }
        });
        GridPanel north = new GridPanel(5, 4, 10, 10);
        north.setInsets(new Insets(10, 5, 5, 10));
        north.add(4, 0, this.quit);
        north.add(4, 1, this.generate);
        north.add(4, 2, this.options);
        north.add(4, 3, this.stop);
        north.add(0, 0, 7, new Label("Lexical specification:"));
        north.add(0, 1, 2, 1, this.spec);
        north.add(2, 1, this.specChoose);
        north.add(0, 2, 7, new Label("Output directory:"));
        north.add(0, 3, 2, 1, this.dir);
        north.add(2, 3, this.dirChoose);
        Panel center = new Panel(new BorderLayout());
        center.add("North", new Label("Messages:"));
        center.add("Center", this.messages);
        this.add("North", north);
        this.add("Center", center);
        this.setEnabledAll(false);
    }

    protected void showOptions() {
        if (this.dialog == null) {
            this.dialog = new OptionsDialog(this);
        }
        this.dialog.show();
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = this.messages.getPreferredSize().width;
        return d;
    }

    private void setEnabledAll(boolean generating) {
        this.stop.setEnabled(generating);
        this.quit.setEnabled(!generating);
        this.generate.setEnabled(!generating);
        this.dirChoose.setEnabled(!generating);
        this.dir.setEnabled(!generating);
        this.specChoose.setEnabled(!generating);
        this.spec.setEnabled(!generating);
    }

    private void generate() {
        if (this.choosing) {
            return;
        }
        this.setEnabledAll(true);
        this.thread = new GeneratorThread(this, this.fileName, this.dirName);
        this.thread.start();
    }

    public void generationFinished(boolean success) {
        this.setEnabledAll(false);
        if (success) {
            this.messages.append(Out.NL + "Generation finished successfully." + Out.NL);
        } else {
            this.messages.append(Out.NL + "Generation aborted." + Out.NL);
        }
    }

    private void stop() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
        this.generationFinished(false);
    }

    private void quit() {
        ((Component)this).setVisible(false);
        System.exit(0);
    }

    private void dirChoose() {
        this.choosing = true;
        FileDialog d = new FileDialog((Frame)this, "Choose directory", 0);
        d.show();
        if (d.getDirectory() != null) {
            this.dir.setText(new File(d.getDirectory()).getAbsolutePath());
        }
        this.choosing = false;
    }

    private void specChoose() {
        this.choosing = true;
        FileDialog d = new FileDialog((Frame)this, "Choose file", 0);
        d.setFile("*.flex");
        d.show();
        if (d.getFile() != null) {
            this.fileName = d.getDirectory() + d.getFile();
            this.dir.setText(d.getDirectory());
            this.spec.setText(this.fileName);
        }
        this.choosing = false;
    }
}

