/* The following code was generated by JFlex 1.4.2 on 11.06.13 12:01 */

/*
 * Copyright (C) 2009-2012 University of Freiburg
 *
 * This file is part of SMTInterpol.
 *
 * SMTInterpol is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * SMTInterpol is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with SMTInterpol.  If not, see <http://www.gnu.org/licenses/>.
 */
/* SMT-Lib lexer */
package de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2;
import java.math.BigDecimal;
import java.math.BigInteger;
import java_cup.runtime.Symbol;
import de.uni_freiburg.informatik.ultimate.util.UnifyHash;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.MySymbolFactory;

/**
 * This is a autogenerated lexer for the smtlib 2 script files.
 * It is generated from smtlib.flex by JFlex.
 */

public class Lexer implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int STRING = 2;
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1, 1
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\3\1\2\1\0\1\3\1\1\22\0\1\3\1\24\1\70"+
    "\1\12\3\5\1\0\1\21\1\22\2\5\1\0\1\35\1\11\1\5"+
    "\1\7\1\17\10\10\1\20\1\4\5\5\1\50\1\14\1\45\1\43"+
    "\1\44\1\14\1\65\1\5\1\46\2\5\1\51\1\47\1\60\3\5"+
    "\1\62\1\63\1\64\1\61\5\5\1\0\1\71\1\0\1\5\1\23"+
    "\1\0\1\25\1\16\1\32\1\42\1\27\1\53\1\54\1\33\1\40"+
    "\1\5\1\34\1\52\1\55\1\37\1\36\1\56\1\5\1\30\1\26"+
    "\1\31\1\41\1\57\1\67\1\13\1\66\1\5\1\0\1\15\1\0"+
    "\1\5\53\0\1\5\12\0\1\5\4\0\1\5\5\0\27\5\1\0"+
    "\37\5\1\0\u01ca\5\4\0\14\5\16\0\5\5\7\0\1\5\1\0"+
    "\1\5\201\0\5\5\1\0\2\5\2\0\4\5\10\0\1\5\1\0"+
    "\3\5\1\0\1\5\1\0\24\5\1\0\123\5\1\0\213\5\10\0"+
    "\236\5\11\0\46\5\2\0\1\5\7\0\47\5\110\0\33\5\5\0"+
    "\3\5\55\0\53\5\25\0\12\6\4\0\2\5\1\0\143\5\1\0"+
    "\1\5\17\0\2\5\7\0\2\5\12\6\3\5\2\0\1\5\20\0"+
    "\1\5\1\0\36\5\35\0\131\5\13\0\1\5\16\0\12\6\41\5"+
    "\11\0\2\5\4\0\1\5\5\0\26\5\4\0\1\5\11\0\1\5"+
    "\3\0\1\5\27\0\31\5\253\0\66\5\3\0\1\5\22\0\1\5"+
    "\7\0\12\5\4\0\12\6\1\0\7\5\1\0\7\5\5\0\10\5"+
    "\2\0\2\5\2\0\26\5\1\0\7\5\1\0\1\5\3\0\4\5"+
    "\3\0\1\5\20\0\1\5\15\0\2\5\1\0\3\5\4\0\12\6"+
    "\2\5\23\0\6\5\4\0\2\5\2\0\26\5\1\0\7\5\1\0"+
    "\2\5\1\0\2\5\1\0\2\5\37\0\4\5\1\0\1\5\7\0"+
    "\12\6\2\0\3\5\20\0\11\5\1\0\3\5\1\0\26\5\1\0"+
    "\7\5\1\0\2\5\1\0\5\5\3\0\1\5\22\0\1\5\17\0"+
    "\2\5\4\0\12\6\25\0\10\5\2\0\2\5\2\0\26\5\1\0"+
    "\7\5\1\0\2\5\1\0\5\5\3\0\1\5\36\0\2\5\1\0"+
    "\3\5\4\0\12\6\1\0\1\5\21\0\1\5\1\0\6\5\3\0"+
    "\3\5\1\0\4\5\3\0\2\5\1\0\1\5\1\0\2\5\3\0"+
    "\2\5\3\0\3\5\3\0\14\5\26\0\1\5\25\0\12\6\25\0"+
    "\10\5\1\0\3\5\1\0\27\5\1\0\12\5\1\0\5\5\3\0"+
    "\1\5\32\0\2\5\6\0\2\5\4\0\12\6\25\0\10\5\1\0"+
    "\3\5\1\0\27\5\1\0\12\5\1\0\5\5\3\0\1\5\40\0"+
    "\1\5\1\0\2\5\4\0\12\6\1\0\2\5\22\0\10\5\1\0"+
    "\3\5\1\0\51\5\2\0\1\5\20\0\1\5\21\0\2\5\4\0"+
    "\12\6\12\0\6\5\5\0\22\5\3\0\30\5\1\0\11\5\1\0"+
    "\1\5\2\0\7\5\72\0\60\5\1\0\2\5\14\0\7\5\11\0"+
    "\12\6\47\0\2\5\1\0\1\5\2\0\2\5\1\0\1\5\2\0"+
    "\1\5\6\0\4\5\1\0\7\5\1\0\3\5\1\0\1\5\1\0"+
    "\1\5\2\0\2\5\1\0\4\5\1\0\2\5\11\0\1\5\2\0"+
    "\5\5\1\0\1\5\11\0\12\6\2\0\2\5\42\0\1\5\37\0"+
    "\12\6\26\0\10\5\1\0\44\5\33\0\5\5\163\0\53\5\24\0"+
    "\1\5\12\6\6\0\6\5\4\0\4\5\3\0\1\5\3\0\2\5"+
    "\7\0\3\5\4\0\15\5\14\0\1\5\1\0\12\6\6\0\46\5"+
    "\12\0\53\5\1\0\1\5\3\0\u0149\5\1\0\4\5\2\0\7\5"+
    "\1\0\1\5\1\0\4\5\2\0\51\5\1\0\4\5\2\0\41\5"+
    "\1\0\4\5\2\0\7\5\1\0\1\5\1\0\4\5\2\0\17\5"+
    "\1\0\71\5\1\0\4\5\2\0\103\5\45\0\20\5\20\0\125\5"+
    "\14\0\u026c\5\2\0\21\5\1\0\32\5\5\0\113\5\25\0\15\5"+
    "\1\0\4\5\16\0\22\5\16\0\22\5\16\0\15\5\1\0\3\5"+
    "\17\0\64\5\43\0\1\5\4\0\1\5\3\0\12\6\46\0\12\6"+
    "\6\0\130\5\10\0\51\5\1\0\1\5\5\0\106\5\12\0\35\5"+
    "\51\0\12\6\36\5\2\0\5\5\13\0\54\5\25\0\7\5\10\0"+
    "\12\6\46\0\27\5\11\0\65\5\53\0\12\6\6\0\12\6\15\0"+
    "\1\5\135\0\57\5\21\0\7\5\4\0\12\6\51\0\36\5\15\0"+
    "\2\5\12\6\6\0\46\5\32\0\44\5\34\0\12\6\3\0\3\5"+
    "\12\6\44\5\153\0\4\5\1\0\4\5\16\0\300\5\100\0\u0116\5"+
    "\2\0\6\5\2\0\46\5\2\0\6\5\2\0\10\5\1\0\1\5"+
    "\1\0\1\5\1\0\1\5\1\0\37\5\2\0\65\5\1\0\7\5"+
    "\1\0\1\5\3\0\3\5\1\0\7\5\3\0\4\5\2\0\6\5"+
    "\4\0\15\5\5\0\3\5\1\0\7\5\164\0\1\5\15\0\1\5"+
    "\20\0\15\5\145\0\1\5\4\0\1\5\2\0\12\5\1\0\1\5"+
    "\3\0\5\5\6\0\1\5\1\0\1\5\1\0\1\5\1\0\4\5"+
    "\1\0\13\5\2\0\4\5\5\0\5\5\4\0\1\5\64\0\2\5"+
    "\u0a7b\0\57\5\1\0\57\5\1\0\205\5\6\0\4\5\21\0\46\5"+
    "\12\0\66\5\11\0\1\5\20\0\27\5\11\0\7\5\1\0\7\5"+
    "\1\0\7\5\1\0\7\5\1\0\7\5\1\0\7\5\1\0\7\5"+
    "\1\0\7\5\120\0\1\5\u01d5\0\2\5\52\0\5\5\5\0\2\5"+
    "\4\0\126\5\6\0\3\5\1\0\132\5\1\0\4\5\5\0\51\5"+
    "\3\0\136\5\21\0\33\5\65\0\20\5\u0200\0\u19b6\5\112\0\u51cc\5"+
    "\64\0\u048d\5\103\0\56\5\2\0\u010d\5\3\0\20\5\12\6\2\5"+
    "\24\0\57\5\20\0\31\5\10\0\106\5\61\0\11\5\2\0\147\5"+
    "\2\0\4\5\1\0\2\5\16\0\12\5\120\0\10\5\1\0\3\5"+
    "\1\0\4\5\1\0\27\5\35\0\64\5\16\0\62\5\34\0\12\6"+
    "\30\0\6\5\3\0\1\5\4\0\12\6\34\5\12\0\27\5\31\0"+
    "\35\5\7\0\57\5\34\0\1\5\12\6\46\0\51\5\27\0\3\5"+
    "\1\0\10\5\4\0\12\6\6\0\27\5\3\0\1\5\5\0\60\5"+
    "\1\0\1\5\3\0\2\5\2\0\5\5\2\0\1\5\1\0\1\5"+
    "\30\0\3\5\43\0\6\5\2\0\6\5\2\0\6\5\11\0\7\5"+
    "\1\0\7\5\221\0\43\5\15\0\12\6\6\0\u2ba4\5\14\0\27\5"+
    "\4\0\61\5\u2104\0\u012e\5\2\0\76\5\2\0\152\5\46\0\7\5"+
    "\14\0\5\5\5\0\1\5\1\0\12\5\1\0\15\5\1\0\5\5"+
    "\1\0\1\5\1\0\2\5\1\0\2\5\1\0\154\5\41\0\u016b\5"+
    "\22\0\100\5\2\0\66\5\50\0\14\5\164\0\5\5\1\0\207\5"+
    "\23\0\12\6\7\0\32\5\6\0\32\5\13\0\131\5\3\0\6\5"+
    "\2\0\6\5\2\0\6\5\2\0\3\5\43\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\2\0\1\1\3\2\1\3\2\4\3\1\1\5\1\6"+
    "\1\7\1\10\22\3\1\11\1\12\1\13\1\14\4\0"+
    "\1\15\14\16\1\17\36\3\1\20\1\14\1\21\1\22"+
    "\1\23\22\16\1\3\1\24\24\3\1\25\5\3\1\26"+
    "\1\27\3\3\24\16\5\3\1\30\1\3\1\31\1\3"+
    "\1\32\4\3\1\33\16\3\1\34\2\3\16\16\1\35"+
    "\5\16\7\3\1\36\1\37\1\3\1\40\5\3\1\41"+
    "\5\3\1\42\1\43\13\3\1\16\1\44\6\16\1\45"+
    "\1\46\12\16\1\47\5\3\1\50\1\51\12\3\1\52"+
    "\7\3\1\53\1\3\1\54\21\16\1\55\1\16\4\3"+
    "\1\56\4\3\1\57\2\3\1\60\2\3\1\61\10\3"+
    "\1\62\7\16\1\63\6\16\1\64\3\16\1\3\1\65"+
    "\1\3\1\66\15\3\1\67\4\3\6\16\1\70\4\16"+
    "\1\71\4\16\1\3\1\72\1\3\1\73\15\3\1\74"+
    "\1\75\1\76\20\16\1\77\1\100\2\3\1\101\5\3"+
    "\1\102\2\3\1\103\2\3\2\16\1\104\5\16\1\105"+
    "\7\16\3\3\1\106\1\3\1\107\1\110\4\3\3\16"+
    "\1\111\12\16\1\112\2\3\1\113\4\3\15\16\6\3"+
    "\14\16\1\114\1\3\1\115\1\116\1\117\1\3\1\120"+
    "\12\16\1\121\1\122\2\3\12\16\1\3\1\123\4\16"+
    "\1\124\2\16\1\125\2\16\1\3\1\126\1\127\6\16"+
    "\1\3\1\130\5\16\1\131\3\16\1\132\1\133\6\16"+
    "\1\134\1\135\3\16\1\136";

  private static int [] zzUnpackAction() {
    int [] result = new int[607];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\72\0\164\0\256\0\164\0\350\0\u0122\0\u015c"+
    "\0\u0196\0\u01d0\0\u020a\0\u0244\0\164\0\164\0\u0122\0\u0122"+
    "\0\u027e\0\u02b8\0\u02f2\0\u032c\0\u0366\0\u03a0\0\u03da\0\u0414"+
    "\0\u044e\0\u0488\0\u04c2\0\u04fc\0\u0536\0\u0570\0\u05aa\0\u05e4"+
    "\0\u061e\0\u0658\0\164\0\u0692\0\164\0\u06cc\0\u0706\0\u0740"+
    "\0\u077a\0\u020a\0\164\0\u07b4\0\u07ee\0\u0828\0\u0862\0\u089c"+
    "\0\u08d6\0\u0910\0\u094a\0\u0984\0\u09be\0\u09f8\0\u0a32\0\u0a6c"+
    "\0\u0aa6\0\u0ae0\0\u0b1a\0\u0b54\0\u0b8e\0\u0bc8\0\u0c02\0\u0c3c"+
    "\0\u0c76\0\u0cb0\0\u0cea\0\u0d24\0\u0d5e\0\u0d98\0\u0dd2\0\u0e0c"+
    "\0\u0e46\0\u0e80\0\u0eba\0\u0ef4\0\u0f2e\0\u0f68\0\u0fa2\0\u0fdc"+
    "\0\u1016\0\u1050\0\u108a\0\u10c4\0\u10fe\0\u1138\0\164\0\164"+
    "\0\u0706\0\u0740\0\u077a\0\u1172\0\u11ac\0\u11e6\0\u1220\0\u125a"+
    "\0\u1294\0\u12ce\0\u1308\0\u1342\0\u137c\0\u13b6\0\u13f0\0\u142a"+
    "\0\u1464\0\u149e\0\u14d8\0\u1512\0\u154c\0\u1586\0\u0122\0\u15c0"+
    "\0\u15fa\0\u1634\0\u166e\0\u16a8\0\u16e2\0\u171c\0\u1756\0\u1790"+
    "\0\u17ca\0\u1804\0\u183e\0\u1878\0\u18b2\0\u18ec\0\u1926\0\u1960"+
    "\0\u199a\0\u19d4\0\u1a0e\0\u0122\0\u1a48\0\u1a82\0\u1abc\0\u1af6"+
    "\0\u1b30\0\u0122\0\u0122\0\u1b6a\0\u1ba4\0\u1bde\0\u1c18\0\u1c52"+
    "\0\u1c8c\0\u1cc6\0\u1d00\0\u1d3a\0\u1d74\0\u1dae\0\u1de8\0\u1e22"+
    "\0\u1e5c\0\u1e96\0\u1ed0\0\u1f0a\0\u1f44\0\u1f7e\0\u1fb8\0\u1ff2"+
    "\0\u202c\0\u2066\0\u20a0\0\u20da\0\u2114\0\u214e\0\u2188\0\u0122"+
    "\0\u21c2\0\u0122\0\u21fc\0\u0122\0\u2236\0\u2270\0\u22aa\0\u22e4"+
    "\0\u0122\0\u231e\0\u2358\0\u2392\0\u23cc\0\u2406\0\u2440\0\u247a"+
    "\0\u24b4\0\u24ee\0\u2528\0\u2562\0\u259c\0\u25d6\0\u2610\0\u0122"+
    "\0\u264a\0\u2684\0\u26be\0\u26f8\0\u2732\0\u276c\0\u27a6\0\u27e0"+
    "\0\u281a\0\u2854\0\u288e\0\u28c8\0\u2902\0\u293c\0\u2976\0\u29b0"+
    "\0\u29ea\0\u2a24\0\u2a5e\0\u2a98\0\u2ad2\0\u2b0c\0\u2b46\0\u2b80"+
    "\0\u2bba\0\u2bf4\0\u2c2e\0\u2c68\0\u2ca2\0\u0122\0\u0122\0\u2cdc"+
    "\0\u0122\0\u2d16\0\u2d50\0\u2d8a\0\u2dc4\0\u2dfe\0\u0122\0\u2e38"+
    "\0\u2e72\0\u2eac\0\u2ee6\0\u2f20\0\u0122\0\u0122\0\u2f5a\0\u2f94"+
    "\0\u2fce\0\u3008\0\u3042\0\u307c\0\u30b6\0\u30f0\0\u312a\0\u3164"+
    "\0\u319e\0\u31d8\0\u3212\0\u324c\0\u3286\0\u32c0\0\u32fa\0\u3334"+
    "\0\u336e\0\u07b4\0\u07b4\0\u33a8\0\u33e2\0\u341c\0\u3456\0\u3490"+
    "\0\u34ca\0\u3504\0\u353e\0\u3578\0\u35b2\0\u0122\0\u35ec\0\u3626"+
    "\0\u3660\0\u369a\0\u36d4\0\u0122\0\u0122\0\u370e\0\u3748\0\u3782"+
    "\0\u37bc\0\u37f6\0\u3830\0\u386a\0\u38a4\0\u38de\0\u3918\0\u0122"+
    "\0\u3952\0\u398c\0\u39c6\0\u3a00\0\u3a3a\0\u3a74\0\u3aae\0\u0122"+
    "\0\u3ae8\0\u0122\0\u3b22\0\u3b5c\0\u3b96\0\u3bd0\0\u3c0a\0\u3c44"+
    "\0\u3c7e\0\u3cb8\0\u3cf2\0\u3d2c\0\u3d66\0\u3da0\0\u3dda\0\u3e14"+
    "\0\u3e4e\0\u3e88\0\u3ec2\0\u07b4\0\u3efc\0\u3f36\0\u3f70\0\u3faa"+
    "\0\u3fe4\0\u0122\0\u401e\0\u4058\0\u4092\0\u40cc\0\u0122\0\u4106"+
    "\0\u4140\0\u0122\0\u417a\0\u41b4\0\u0122\0\u41ee\0\u4228\0\u4262"+
    "\0\u429c\0\u42d6\0\u4310\0\u434a\0\u4384\0\u0122\0\u43be\0\u43f8"+
    "\0\u4432\0\u446c\0\u44a6\0\u44e0\0\u451a\0\u07b4\0\u4554\0\u458e"+
    "\0\u45c8\0\u4602\0\u463c\0\u4676\0\u07b4\0\u46b0\0\u46ea\0\u4724"+
    "\0\u475e\0\u0122\0\u4798\0\u0122\0\u47d2\0\u480c\0\u4846\0\u4880"+
    "\0\u48ba\0\u48f4\0\u492e\0\u4968\0\u49a2\0\u49dc\0\u4a16\0\u4a50"+
    "\0\u4a8a\0\u0122\0\u4ac4\0\u4afe\0\u4b38\0\u4b72\0\u4bac\0\u4be6"+
    "\0\u4c20\0\u4c5a\0\u4c94\0\u4cce\0\u07b4\0\u4d08\0\u4d42\0\u4d7c"+
    "\0\u4db6\0\u07b4\0\u4df0\0\u4e2a\0\u4e64\0\u4e9e\0\u4ed8\0\u0122"+
    "\0\u4f12\0\u0122\0\u4f4c\0\u4f86\0\u4fc0\0\u4ffa\0\u5034\0\u506e"+
    "\0\u50a8\0\u50e2\0\u511c\0\u5156\0\u5190\0\u51ca\0\u5204\0\u0122"+
    "\0\u0122\0\u0122\0\u523e\0\u5278\0\u52b2\0\u52ec\0\u5326\0\u5360"+
    "\0\u539a\0\u53d4\0\u540e\0\u5448\0\u5482\0\u54bc\0\u54f6\0\u5530"+
    "\0\u556a\0\u55a4\0\u07b4\0\u0122\0\u55de\0\u5618\0\u0122\0\u5652"+
    "\0\u568c\0\u56c6\0\u5700\0\u573a\0\u0122\0\u5774\0\u57ae\0\u0122"+
    "\0\u57e8\0\u5822\0\u585c\0\u5896\0\u07b4\0\u58d0\0\u590a\0\u5944"+
    "\0\u597e\0\u59b8\0\u07b4\0\u59f2\0\u5a2c\0\u5a66\0\u5aa0\0\u5ada"+
    "\0\u5b14\0\u5b4e\0\u5b88\0\u5bc2\0\u5bfc\0\u0122\0\u5c36\0\u0122"+
    "\0\u0122\0\u5c70\0\u5caa\0\u5ce4\0\u5d1e\0\u5d58\0\u5d92\0\u5dcc"+
    "\0\u07b4\0\u5e06\0\u5e40\0\u5e7a\0\u5eb4\0\u5eee\0\u5f28\0\u5f62"+
    "\0\u5f9c\0\u5fd6\0\u6010\0\u0122\0\u604a\0\u6084\0\u0122\0\u60be"+
    "\0\u60f8\0\u6132\0\u616c\0\u61a6\0\u61e0\0\u621a\0\u6254\0\u628e"+
    "\0\u62c8\0\u6302\0\u633c\0\u6376\0\u63b0\0\u63ea\0\u6424\0\u645e"+
    "\0\u6498\0\u64d2\0\u650c\0\u6546\0\u6580\0\u65ba\0\u65f4\0\u662e"+
    "\0\u6668\0\u66a2\0\u66dc\0\u6716\0\u6750\0\u678a\0\u67c4\0\u67fe"+
    "\0\u6838\0\u6872\0\u07b4\0\u68ac\0\u0122\0\u0122\0\u0122\0\u68e6"+
    "\0\u0122\0\u6920\0\u695a\0\u6994\0\u69ce\0\u6a08\0\u6a42\0\u6a7c"+
    "\0\u6ab6\0\u6af0\0\u6b2a\0\u07b4\0\u07b4\0\u6b64\0\u6b9e\0\u6bd8"+
    "\0\u6c12\0\u6c4c\0\u6c86\0\u6cc0\0\u6cfa\0\u6d34\0\u6d6e\0\u6da8"+
    "\0\u6de2\0\u6e1c\0\u0122\0\u6e56\0\u6e90\0\u6eca\0\u6f04\0\u07b4"+
    "\0\u6f3e\0\u6f78\0\u07b4\0\u6fb2\0\u6fec\0\u7026\0\u07b4\0\u07b4"+
    "\0\u7060\0\u709a\0\u70d4\0\u710e\0\u7148\0\u7182\0\u71bc\0\u07b4"+
    "\0\u71f6\0\u7230\0\u726a\0\u72a4\0\u72de\0\u0122\0\u7318\0\u7352"+
    "\0\u738c\0\u07b4\0\u07b4\0\u73c6\0\u7400\0\u743a\0\u7474\0\u74ae"+
    "\0\u74e8\0\u07b4\0\u07b4\0\u7522\0\u755c\0\u7596\0\u07b4";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[607];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\3\1\4\2\5\1\6\1\7\1\3\1\10\1\11"+
    "\1\7\1\12\2\7\1\13\1\7\1\11\1\14\1\15"+
    "\1\16\1\17\1\20\1\21\1\22\1\23\1\24\1\25"+
    "\1\26\4\7\1\27\1\30\1\31\1\32\1\33\6\7"+
    "\1\34\1\35\1\36\1\37\1\40\1\7\1\41\2\7"+
    "\1\42\4\7\1\43\1\3\70\44\1\45\1\46\74\0"+
    "\1\5\67\0\1\6\1\4\1\5\67\6\5\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\45\7\13\0\1\47"+
    "\67\0\2\11\1\47\5\0\1\11\65\0\1\50\2\0"+
    "\1\51\53\0\15\52\1\53\54\52\5\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\3\54\1\55\1\56\1\57"+
    "\1\60\5\54\1\61\1\62\1\54\1\63\7\54\1\64"+
    "\1\65\2\54\1\66\1\67\10\54\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\3\7\1\70\41\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\2\7\1\71"+
    "\1\7\1\72\10\7\1\73\1\74\26\7\7\0\5\7"+
    "\1\0\1\75\1\7\1\0\2\7\3\0\5\7\1\76"+
    "\1\7\1\77\35\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\4\7\1\100\40\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\5\7\1\101\2\7\1\102"+
    "\4\7\1\103\27\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\10\7\1\104\2\7\1\105\31\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\13\7\1\106"+
    "\31\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\14\7\1\107\15\7\1\110\12\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\14\7\1\111\30\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\4\7\1\112"+
    "\40\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\21\7\1\113\23\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\4\7\1\114\6\7\1\115\31\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\2\7\1\116"+
    "\10\7\1\117\31\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\4\7\1\120\40\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\4\7\1\121\40\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\2\7\1\122"+
    "\10\7\1\123\2\7\1\124\26\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\36\7\1\125\6\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\41\7\1\126"+
    "\3\7\2\0\70\44\72\0\1\127\1\130\7\0\2\131"+
    "\6\0\1\131\61\0\2\132\3\0\1\132\1\0\2\132"+
    "\5\0\1\132\1\0\1\132\2\0\1\132\7\0\4\132"+
    "\2\0\1\132\2\0\1\132\25\0\1\133\7\0\1\133"+
    "\57\0\5\54\1\0\2\54\1\0\2\54\3\0\45\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\6\54"+
    "\1\134\4\54\1\135\31\54\7\0\5\54\1\0\1\136"+
    "\1\54\1\0\2\54\3\0\45\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\2\54\1\137\1\54\1\140"+
    "\40\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\10\54\1\141\4\54\1\142\27\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\2\54\1\143\10\54\1\144"+
    "\31\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\14\54\1\145\30\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\4\54\1\146\10\54\1\147\27\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\2\54\1\150"+
    "\42\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\16\54\1\151\26\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\2\54\1\152\2\54\1\153\37\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\2\54\1\154"+
    "\1\54\1\155\40\54\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\3\7\1\156\41\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\6\7\1\157\36\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\6\7\1\160"+
    "\36\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\32\7\1\161\12\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\7\7\1\162\35\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\15\7\1\163\27\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\5\7\1\164"+
    "\37\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\10\7\1\165\34\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\3\7\1\166\41\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\16\7\1\167\26\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\4\7\1\170"+
    "\40\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\32\7\1\171\12\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\4\7\1\172\40\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\14\7\1\173\30\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\14\7\1\174"+
    "\30\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\7\7\1\175\35\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\32\7\1\176\12\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\3\7\1\177\5\7\1\200"+
    "\33\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\7\7\1\201\20\7\1\202\14\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\22\7\1\203\22\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\6\7\1\204"+
    "\36\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\31\7\1\205\13\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\27\7\1\206\15\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\5\7\1\207\37\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\6\7\1\210"+
    "\36\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\32\7\1\211\12\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\5\7\1\212\37\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\33\7\1\213\11\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\3\7\1\214"+
    "\41\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\24\7\1\215\20\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\37\7\1\216\5\7\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\5\54\1\217\37\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\5\54\1\220"+
    "\37\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\6\54\1\221\24\54\1\222\11\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\14\54\1\223\30\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\31\54\1\224"+
    "\13\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\4\54\1\225\40\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\32\54\1\226\12\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\32\54\1\227\12\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\6\54\1\230"+
    "\36\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\6\54\1\231\36\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\30\54\1\232\14\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\2\54\1\233\42\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\14\54\1\234"+
    "\30\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\14\54\1\235\30\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\6\54\1\236\36\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\13\54\1\237\1\54\1\240"+
    "\27\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\27\54\1\241\15\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\5\54\1\242\37\54\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\4\7\1\243\40\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\12\7\1\244"+
    "\32\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\33\7\1\245\11\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\7\7\1\246\35\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\3\7\1\247\2\7\1\250"+
    "\36\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\13\7\1\251\31\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\13\7\1\252\31\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\4\7\1\253\40\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\4\7\1\254"+
    "\40\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\13\7\1\255\31\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\4\7\1\256\40\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\7\7\1\257\35\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\6\7\1\260"+
    "\36\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\4\7\1\261\40\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\13\7\1\262\13\7\1\263\15\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\4\7\1\264"+
    "\40\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\2\7\1\265\13\7\1\266\26\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\14\7\1\267\30\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\27\7\1\270"+
    "\15\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\15\7\1\271\27\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\23\7\1\272\21\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\15\7\1\273\27\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\3\7\1\274"+
    "\41\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\2\7\1\275\42\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\12\7\1\276\32\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\13\7\1\277\31\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\10\7\1\300"+
    "\34\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\21\7\1\301\23\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\23\7\1\302\21\7\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\13\54\1\303\31\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\6\54\1\304"+
    "\36\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\4\54\1\305\40\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\2\54\1\306\42\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\17\54\1\307\25\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\16\54\1\310"+
    "\26\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\13\54\1\311\31\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\4\54\1\312\40\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\4\54\1\313\40\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\4\54\1\314"+
    "\40\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\4\54\1\315\40\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\15\54\1\316\27\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\31\54\1\317\13\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\31\54\1\320"+
    "\13\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\3\54\1\321\41\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\6\54\1\322\36\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\17\54\1\323\25\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\14\54\1\324"+
    "\30\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\16\54\1\325\26\54\7\0\5\54\1\0\2\54\1\0"+
    "\1\326\1\54\3\0\45\54\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\5\7\1\327\37\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\13\7\1\330\1\7"+
    "\1\331\11\7\1\332\15\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\27\7\1\333\15\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\4\7\1\334\40\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\6\7"+
    "\1\335\36\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\5\7\1\336\37\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\6\7\1\337\36\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\5\7\1\340\37\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\17\7"+
    "\1\341\25\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\11\7\1\342\33\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\15\7\1\343\27\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\32\7\1\344\12\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\16\7"+
    "\1\345\26\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\17\7\1\346\25\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\6\7\1\347\36\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\33\7\1\350\11\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\13\7"+
    "\1\351\31\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\2\7\1\352\42\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\14\7\1\353\30\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\24\7\1\354\20\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\7\7"+
    "\1\355\35\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\4\7\1\356\40\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\27\7\1\357\15\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\2\7\1\360\10\7"+
    "\1\361\1\7\1\362\1\363\13\7\1\364\1\365\1\366"+
    "\10\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\16\7\1\367\26\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\37\7\1\370\5\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\35\7\1\371\7\7\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\14\54\1\372"+
    "\30\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\3\54\1\373\41\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\14\54\1\374\30\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\14\54\1\375\30\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\13\54\1\376"+
    "\31\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\27\54\1\377\15\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\5\54\1\u0100\37\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\13\54\1\u0101\31\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\17\54\1\u0102"+
    "\25\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\3\54\1\u0103\41\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\5\54\1\u0104\37\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\14\54\1\u0105\30\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\14\54\1\u0106"+
    "\30\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\16\54\1\u0107\26\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\12\54\1\u0108\32\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\4\54\1\u0109\40\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\16\54\1\u010a"+
    "\26\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\6\54\1\u010b\36\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\4\54\1\u010c\40\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\13\54\1\u010d\31\54\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\6\7\1\u010e"+
    "\36\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\33\7\1\u010f\11\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\14\7\1\u0110\30\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\13\7\1\u0111\31\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\15\7\1\u0112"+
    "\27\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\3\7\1\u0113\41\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\3\7\1\u0114\41\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\43\7\1\u0115\1\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\12\7\1\u0116"+
    "\32\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\14\7\1\u0117\30\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\33\7\1\u0118\11\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\17\7\1\u0119\25\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\15\7\1\u011a"+
    "\27\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\33\7\1\u011b\11\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\44\7\1\u011c\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\5\7\1\u011d\37\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\4\7\1\u011e\40\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\25\7"+
    "\1\u011f\17\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\27\7\1\u0120\15\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\3\7\1\u0121\41\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\33\7\1\u0122\11\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\14\7"+
    "\1\u0123\30\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\14\7\1\u0124\30\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\13\7\1\u0125\31\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\5\7\1\u0126\37\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\2\7"+
    "\1\u0127\42\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\6\7\1\u0128\36\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\25\7\1\u0129\17\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\42\7\1\u012a\2\7"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\31\54"+
    "\1\u012b\13\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\12\54\1\u012c\32\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\3\54\1\u012d\41\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\17\54\1\u012e\25\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\32\54"+
    "\1\u012f\12\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\2\54\1\u0130\42\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\15\54\1\u0131\27\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\16\54\1\u0132\26\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\2\54"+
    "\1\u0133\30\54\1\u0134\11\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\15\54\1\u0135\27\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\13\54\1\u0136\31\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\2\54"+
    "\1\u0137\42\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\17\54\1\u0138\25\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\5\54\1\u0139\37\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\7\54\1\u013a\35\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\12\54"+
    "\1\u013b\32\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\3\54\1\u013c\41\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\3\54\1\u013d\41\54\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\6\7\1\u013e\36\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\30\7"+
    "\1\u013f\14\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\31\7\1\u0140\13\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\30\7\1\u0141\14\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\3\7\1\u0142\41\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\2\7"+
    "\1\u0143\1\u0144\41\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\16\7\1\u0145\26\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\27\7\1\u0146\15\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\4\7\1\u0147"+
    "\40\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\2\7\1\u0148\42\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\13\7\1\u0149\31\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\14\7\1\u014a\30\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\4\7\1\u014b"+
    "\40\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\12\7\1\u014c\32\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\26\7\1\u014d\16\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\3\7\1\u014e\41\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\6\7\1\u014f"+
    "\36\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\6\7\1\u0150\21\7\1\u0151\14\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\3\7\1\u0152\41\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\17\7\1\u0153"+
    "\25\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\13\7\1\u0154\31\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\27\7\1\u0155\15\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\26\7\1\u0156\16\7\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\12\54\1\u0157"+
    "\32\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\17\54\1\u0158\25\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\15\54\1\u0159\27\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\12\54\1\u015a\32\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\12\54\1\u015b"+
    "\32\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\5\54\1\u015c\37\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\4\54\1\u015d\40\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\6\54\1\u015e\36\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\7\54\1\u015f"+
    "\35\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\13\54\1\u0160\31\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\6\54\1\u0161\36\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\3\54\1\u0162\41\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\31\54\1\u0163"+
    "\13\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\4\54\1\u0164\40\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\14\54\1\u0165\30\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\4\54\1\u0166\40\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\3\54\1\u0167"+
    "\41\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\15\54\1\u0168\27\54\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\15\7\1\u0169\27\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\13\7\1\u016a\31\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\15\7\1\u016b"+
    "\27\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\43\7\1\u016c\1\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\27\7\1\u016d\15\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\2\7\1\u016e\42\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\4\7\1\u016f"+
    "\40\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\4\7\1\u0170\40\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\6\7\1\u0171\36\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\5\7\1\u0172\37\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\12\7\1\u0173"+
    "\32\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\3\7\1\u0174\24\7\1\u0175\14\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\4\7\1\u0176\10\7\1\u0177"+
    "\27\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\15\7\1\u0178\27\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\4\7\1\u0179\40\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\13\7\1\u017a\31\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\2\7\1\u017b"+
    "\42\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\4\7\1\u017c\40\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\13\7\1\u017d\31\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\16\7\1\u017e\26\7\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\3\54\1\u017f"+
    "\41\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\4\54\1\u0180\40\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\13\54\1\u0181\31\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\17\54\1\u0182\25\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\3\54\1\u0183"+
    "\41\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\12\54\1\u0184\32\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\3\54\1\u0185\41\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\6\54\1\u0186\36\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\27\54\1\u0187"+
    "\15\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\15\54\1\u0188\27\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\6\54\1\u0189\36\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\4\54\1\u018a\40\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\3\54\1\u018b"+
    "\41\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\12\54\1\u018c\32\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\16\54\1\u018d\26\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\6\54\1\u018e\36\54\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\13\7\1\u018f"+
    "\31\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\7\7\1\u0190\35\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\27\7\1\u0191\15\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\6\7\1\u0192\36\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\17\7\1\u0193"+
    "\25\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\6\7\1\u0194\36\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\4\7\1\u0195\40\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\6\7\1\u0196\36\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\3\7\1\u0197"+
    "\24\7\1\u0198\14\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\13\7\1\u0199\31\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\16\7\1\u019a\26\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\5\7\1\u019b"+
    "\37\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\31\7\1\u019c\13\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\13\7\1\u019d\31\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\5\7\1\u019e\37\7\7\0"+
    "\5\7\1\0\2\7\1\0\2\7\3\0\6\7\1\u019f"+
    "\36\7\7\0\5\7\1\0\2\7\1\0\2\7\3\0"+
    "\27\7\1\u01a0\15\7\7\0\5\7\1\0\2\7\1\0"+
    "\2\7\3\0\30\7\1\u01a1\14\7\7\0\5\7\1\0"+
    "\2\7\1\0\2\7\3\0\4\7\1\u01a2\40\7\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\15\54\1\u01a3"+
    "\27\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\3\54\1\u01a4\41\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\14\54\1\u01a5\30\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\4\54\1\u01a6\40\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\4\54\1\u01a7"+
    "\40\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\13\54\1\u01a8\31\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\15\54\1\u01a9\27\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\2\54\1\u01aa\42\54\7\0"+
    "\5\54\1\0\2\54\1\0\2\54\3\0\13\54\1\u01ab"+
    "\31\54\7\0\5\54\1\0\2\54\1\0\2\54\3\0"+
    "\15\54\1\u01ac\27\54\7\0\5\54\1\0\2\54\1\0"+
    "\2\54\3\0\7\54\1\u01ad\35\54\7\0\5\54\1\0"+
    "\2\54\1\0\2\54\3\0\2\54\1\u01ae\13\54\1\u01af"+
    "\13\54\1\u01b0\1\u01b1\11\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\7\54\1\u01b2\35\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\43\54\1\u01b3\1\54"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\14\7"+
    "\1\u01b4\30\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\3\7\1\u01b5\41\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\12\7\1\u01b6\32\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\4\7\1\u01b7\40\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\12\7"+
    "\1\u01b8\32\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\4\7\1\u01b9\40\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\13\7\1\u01ba\31\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\16\7\1\u01bb\26\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\5\7"+
    "\1\u01bc\37\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\14\7\1\u01bd\30\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\6\7\1\u01be\36\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\14\7\1\u01bf\30\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\14\7"+
    "\1\u01c0\30\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\33\7\1\u01c1\11\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\12\7\1\u01c2\32\7\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\32\54\1\u01c3\12\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\7\54"+
    "\1\u01c4\35\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\3\54\1\u01c5\41\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\30\54\1\u01c6\14\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\4\54\1\u01c7\40\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\16\54"+
    "\1\u01c8\26\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\34\54\1\u01c9\10\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\14\54\1\u01ca\30\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\14\54\1\u01cb\30\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\7\54"+
    "\1\u01cc\35\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\5\54\1\u01cd\37\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\3\54\1\u01ce\41\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\14\54\1\u01cf\30\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\13\54"+
    "\1\u01d0\31\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\5\54\1\u01d1\37\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\7\54\1\u01d2\35\54\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\2\7\1\u01d3\42\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\4\7"+
    "\1\u01d4\40\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\4\7\1\u01d5\40\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\17\7\1\u01d6\25\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\5\7\1\u01d7\37\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\14\7"+
    "\1\u01d8\30\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\6\7\1\u01d9\36\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\15\7\1\u01da\27\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\32\7\1\u01db\12\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\13\7"+
    "\1\u01dc\31\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\7\7\1\u01dd\35\7\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\33\54\1\u01de\11\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\5\54\1\u01df\37\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\15\54"+
    "\1\u01e0\27\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\17\54\1\u01e1\25\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\6\54\1\u01e2\36\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\4\54\1\u01e3\40\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\6\54"+
    "\1\u01e4\36\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\12\54\1\u01e5\32\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\15\54\1\u01e6\27\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\3\54\1\u01e7\41\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\3\54"+
    "\1\u01e8\41\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\17\54\1\u01e9\25\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\13\54\1\u01ea\31\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\4\54\1\u01eb\40\54"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\6\7"+
    "\1\u01ec\36\7\7\0\5\7\1\0\1\u01ed\1\7\1\0"+
    "\2\7\3\0\45\7\7\0\5\7\1\0\1\u01ee\1\7"+
    "\1\0\2\7\3\0\45\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\6\7\1\u01ef\36\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\13\7\1\u01f0\31\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\4\7"+
    "\1\u01f1\40\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\27\7\1\u01f2\15\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\13\7\1\u01f3\31\7\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\27\54\1\u01f4\15\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\15\54"+
    "\1\u01f5\27\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\14\54\1\u01f6\30\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\33\54\1\u01f7\11\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\12\54\1\u01f8\32\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\12\54"+
    "\1\u01f9\32\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\13\54\1\u01fa\31\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\33\54\1\u01fb\11\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\15\54\1\u01fc\27\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\2\54"+
    "\1\u01fd\42\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\4\54\1\u01fe\40\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\13\54\1\u01ff\31\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\3\54\1\u0200\41\54"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\4\7"+
    "\1\u0201\40\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\15\7\1\u0202\27\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\14\7\1\u0203\30\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\14\7\1\u0204\30\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\2\7"+
    "\1\u0205\42\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\5\7\1\u0206\37\7\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\15\54\1\u0207\27\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\33\54\1\u0208\11\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\15\54"+
    "\1\u0209\27\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\16\54\1\u020a\26\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\32\54\1\u020b\12\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\7\54\1\u020c\35\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\16\54"+
    "\1\u020d\26\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\6\54\1\u020e\36\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\31\54\1\u020f\13\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\6\54\1\u0210\36\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\27\54"+
    "\1\u0211\15\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\30\54\1\u0212\14\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\3\54\1\u0213\41\54\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\7\7\1\u0214\35\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\6\7"+
    "\1\u0215\36\7\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\3\7\1\u0216\41\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\6\7\1\u0217\36\7\7\0\5\7"+
    "\1\0\2\7\1\0\2\7\3\0\14\7\1\u0218\30\7"+
    "\7\0\5\7\1\0\2\7\1\0\2\7\3\0\4\7"+
    "\1\u0219\40\7\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\30\54\1\u021a\14\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\6\54\1\u021b\36\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\6\54\1\u021c\36\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\6\54"+
    "\1\u021d\36\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\13\54\1\u021e\31\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\10\54\1\u021f\34\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\6\54\1\u0220\36\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\15\54"+
    "\1\u0221\27\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\14\54\1\u0222\30\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\12\54\1\u0223\32\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\3\54\1\u0224\41\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\3\54"+
    "\1\u0225\41\54\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\16\7\1\u0226\26\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\6\7\1\u0227\36\7\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\15\54\1\u0228\27\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\15\54"+
    "\1\u0229\27\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\15\54\1\u022a\27\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\12\54\1\u022b\32\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\17\54\1\u022c\25\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\4\54"+
    "\1\u022d\40\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\33\54\1\u022e\11\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\13\54\1\u022f\31\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\32\54\1\u0230\12\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\7\54"+
    "\1\u0231\35\54\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\6\7\1\u0232\36\7\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\3\7\1\u0233\41\7\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\4\54\1\u0234\40\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\13\54"+
    "\1\u0235\31\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\13\54\1\u0236\31\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\7\54\1\u0237\35\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\4\54\1\u0238\40\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\7\54"+
    "\1\u0239\35\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\16\54\1\u023a\26\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\14\54\1\u023b\30\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\4\54\1\u023c\40\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\13\54"+
    "\1\u023d\31\54\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\15\7\1\u023e\27\7\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\5\54\1\u023f\37\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\14\54\1\u0240\30\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\14\54"+
    "\1\u0241\30\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\10\54\1\u0242\34\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\11\54\1\u0243\33\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\6\54\1\u0244\36\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\14\54"+
    "\1\u0245\30\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\5\54\1\u0246\37\54\7\0\5\7\1\0\2\7"+
    "\1\0\2\7\3\0\13\7\1\u0247\31\7\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\3\54\1\u0248\41\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\2\54"+
    "\1\u0249\42\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\12\54\1\u024a\32\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\12\54\1\u024b\32\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\6\54\1\u024c\36\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\4\54"+
    "\1\u024d\40\54\7\0\5\7\1\0\2\7\1\0\2\7"+
    "\3\0\14\7\1\u024e\30\7\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\14\54\1\u024f\30\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\32\54\1\u0250\12\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\7\54"+
    "\1\u0251\35\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\3\54\1\u0252\41\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\3\54\1\u0253\41\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\14\54\1\u0254\30\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\13\54"+
    "\1\u0255\31\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\10\54\1\u0256\34\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\4\54\1\u0257\40\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\17\54\1\u0258\25\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\2\54"+
    "\1\u0259\42\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\27\54\1\u025a\15\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\4\54\1\u025b\40\54\7\0\5\54"+
    "\1\0\2\54\1\0\2\54\3\0\14\54\1\u025c\30\54"+
    "\7\0\5\54\1\0\2\54\1\0\2\54\3\0\14\54"+
    "\1\u025d\30\54\7\0\5\54\1\0\2\54\1\0\2\54"+
    "\3\0\4\54\1\u025e\40\54\7\0\5\54\1\0\2\54"+
    "\1\0\2\54\3\0\27\54\1\u025f\15\54\2\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[30160];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\2\0\1\11\1\1\1\11\7\1\2\11\24\1\1\11"+
    "\1\1\1\11\1\1\4\0\1\11\53\1\2\11\u0207\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[607];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
  private StringBuffer string = new StringBuffer();
  private MySymbolFactory symFactory;
  private UnifyHash<BigInteger> bignumbers = new UnifyHash<BigInteger>();
  
  public void setSymbolFactory(MySymbolFactory factory) {
    symFactory = factory;
  }

  private Symbol symbol(int type) {
    return symFactory.newSymbol(yytext(), type, yyline+1, yycolumn, yyline+1, yycolumn+yylength());
  }
  private Symbol symbol(int type, Object value) {
    return symFactory.newSymbol(yytext(), type, yyline+1, yycolumn, yyline+1, yycolumn+yylength(), value);
  }
  
  private BigInteger convertNumeral(String numeral) {
	BigInteger result = new BigInteger(numeral);
	int hash = result.hashCode();
	for (BigInteger integer : bignumbers.iterateHashCode(hash)) {
		if (integer.equals(result))
			return integer;
	}
	bignumbers.put(hash, result);
	return result;
  }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Lexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public Lexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1714) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 68: 
          { return symbol(LexerSymbols.CEXTENSIONS, yytext());
          }
        case 95: break;
        case 19: 
          { return symbol(LexerSymbols.BINARY, yytext());
          }
        case 96: break;
        case 59: 
          { return symbol(LexerSymbols.CHECKSAT, yytext());
          }
        case 97: break;
        case 47: 
          { return symbol(LexerSymbols.INCLUDE, yytext());
          }
        case 98: break;
        case 76: 
          { return symbol(LexerSymbols.CPRINTSUCCESS, yytext());
          }
        case 99: break;
        case 50: 
          { return symbol(LexerSymbols.NUMERALSYM, yytext());
          }
        case 100: break;
        case 86: 
          { return symbol(LexerSymbols.CSTRONGSIMPLIFIER, yytext());
          }
        case 101: break;
        case 60: 
          { return symbol(LexerSymbols.GETMODEL, yytext());
          }
        case 102: break;
        case 93: 
          { return symbol(LexerSymbols.CINTERPOLANTCHECKMODE, yytext());
          }
        case 103: break;
        case 91: 
          { return symbol(LexerSymbols.CPRODUCEUNSATCORES, yytext());
          }
        case 104: break;
        case 53: 
          { return symbol(LexerSymbols.SETINFO, yytext());
          }
        case 105: break;
        case 27: 
          { return symbol(LexerSymbols.NONE, yytext());
          }
        case 106: break;
        case 6: 
          { return symbol(LexerSymbols.RPAR);
          }
        case 107: break;
        case 69: 
          { return symbol(LexerSymbols.CDEFINITION, yytext());
          }
        case 108: break;
        case 55: 
          { return symbol(LexerSymbols.GETINFO, yytext());
          }
        case 109: break;
        case 20: 
          { return symbol(LexerSymbols.SAT, yytext());
          }
        case 110: break;
        case 31: 
          { return symbol(LexerSymbols.RESET, yytext());
          }
        case 111: break;
        case 15: 
          { return symbol(LexerSymbols.AS, yytext());
          }
        case 112: break;
        case 37: 
          { return symbol(LexerSymbols.CNAMED, yytext());
          }
        case 113: break;
        case 5: 
          { return symbol(LexerSymbols.LPAR);
          }
        case 114: break;
        case 16: 
          { string.append('\"');
          }
        case 115: break;
        case 30: 
          { return symbol(LexerSymbols.ERRORSYM, yytext());
          }
        case 116: break;
        case 73: 
          { return symbol(LexerSymbols.CRANDOMSEED, yytext());
          }
        case 117: break;
        case 40: 
          { return symbol(LexerSymbols.EXISTS, yytext());
          }
        case 118: break;
        case 28: 
          { return symbol(LexerSymbols.PUSH, yytext());
          }
        case 119: break;
        case 80: 
          { return symbol(LexerSymbols.GETUNSATCORE, yytext());
          }
        case 120: break;
        case 84: 
          { return symbol(LexerSymbols.CINTERACTIVEMODE, yytext());
          }
        case 121: break;
        case 36: 
          { return symbol(LexerSymbols.CSORTS, yytext());
          }
        case 122: break;
        case 24: 
          { return symbol(LexerSymbols.EXIT, yytext());
          }
        case 123: break;
        case 58: 
          { return symbol(LexerSymbols.SETLOGIC, yytext());
          }
        case 124: break;
        case 92: 
          { return symbol(LexerSymbols.CREGULAROUTPUTCHANNEL, yytext());
          }
        case 125: break;
        case 49: 
          { return symbol(LexerSymbols.DECIMALSYM, yytext());
          }
        case 126: break;
        case 9: 
          { string.setLength(0); yybegin(STRING);
          }
        case 127: break;
        case 17: 
          { return symbol(LexerSymbols.DECIMAL, new BigDecimal(yytext()));
          }
        case 128: break;
        case 90: 
          { return symbol(LexerSymbols.CPRODUCEASSIGNMENTS, yytext());
          }
        case 129: break;
        case 70: 
          { return symbol(LexerSymbols.UNSUPPORTED, yytext());
          }
        case 130: break;
        case 44: 
          { return symbol(LexerSymbols.STRINGSYM, yytext());
          }
        case 131: break;
        case 62: 
          { return symbol(LexerSymbols.GETVALUE, yytext());
          }
        case 132: break;
        case 29: 
          { return symbol(LexerSymbols.CFUNS, yytext());
          }
        case 133: break;
        case 39: 
          { return symbol(LexerSymbols.ASSERT, yytext());
          }
        case 134: break;
        case 51: 
          { return symbol(LexerSymbols.CTIMEOUT, yytext());
          }
        case 135: break;
        case 13: 
          { return symbol(LexerSymbols.SYMBOL, yytext().substring(1, yylength()-1));
          }
        case 136: break;
        case 77: 
          { return symbol(LexerSymbols.IMMEDIATEEXIT, yytext());
          }
        case 137: break;
        case 85: 
          { return symbol(LexerSymbols.CFUNSDESCRIPTION, yytext());
          }
        case 138: break;
        case 32: 
          { return symbol(LexerSymbols.TIMED, yytext());
          }
        case 139: break;
        case 64: 
          { return symbol(LexerSymbols.SETOPTION, yytext());
          }
        case 140: break;
        case 26: 
          { return symbol(LexerSymbols.TRUE, yytext());
          }
        case 141: break;
        case 52: 
          { return symbol(LexerSymbols.CPATTERN, yytext());
          }
        case 142: break;
        case 75: 
          { return symbol(LexerSymbols.DECLARESORT, yytext());
          }
        case 143: break;
        case 35: 
          { return symbol(LexerSymbols.FALSE, yytext());
          }
        case 144: break;
        case 81: 
          { return symbol(LexerSymbols.CPRODUCEMODELS, yytext());
          }
        case 145: break;
        case 23: 
          { return symbol(LexerSymbols.POP, yytext());
          }
        case 146: break;
        case 61: 
          { return symbol(LexerSymbols.GETPROOF, yytext());
          }
        case 147: break;
        case 1: 
          { return symbol(LexerSymbols.error, yytext());
          }
        case 148: break;
        case 34: 
          { return symbol(LexerSymbols.LOGIC, yytext());
          }
        case 149: break;
        case 65: 
          { return symbol(LexerSymbols.INCOMPLETE, yytext());
          }
        case 150: break;
        case 41: 
          { return symbol(LexerSymbols.THEORY, yytext());
          }
        case 151: break;
        case 71: 
          { return symbol(LexerSymbols.DECLAREFUN, yytext());
          }
        case 152: break;
        case 42: 
          { return symbol(LexerSymbols.FORALL, yytext());
          }
        case 153: break;
        case 89: 
          { return symbol(LexerSymbols.CONTINUEDEXECUTION, yytext());
          }
        case 154: break;
        case 48: 
          { return symbol(LexerSymbols.UNKNOWN, yytext());
          }
        case 155: break;
        case 45: 
          { return symbol(LexerSymbols.CVALUES, yytext());
          }
        case 156: break;
        case 25: 
          { return symbol(LexerSymbols.ECHO, yytext());
          }
        case 157: break;
        case 72: 
          { return symbol(LexerSymbols.DEFINESORT, yytext());
          }
        case 158: break;
        case 54: 
          { return symbol(LexerSymbols.SIMPLIFY, yytext());
          }
        case 159: break;
        case 63: 
          { return symbol(LexerSymbols.CVERBOSITY, yytext());
          }
        case 160: break;
        case 38: 
          { return symbol(LexerSymbols.CNOTES, yytext());
          }
        case 161: break;
        case 22: 
          { return symbol(LexerSymbols.PAR, yytext());
          }
        case 162: break;
        case 12: 
          { string.append('\\');
          }
        case 163: break;
        case 57: 
          { return symbol(LexerSymbols.CLANGUAGE, yytext());
          }
        case 164: break;
        case 74: 
          { return symbol(LexerSymbols.ALLSAT, yytext());
          }
        case 165: break;
        case 8: 
          { return symbol(LexerSymbols.BANG, yytext());
          }
        case 166: break;
        case 79: 
          { return symbol(LexerSymbols.GETASSIGNMENT, yytext());
          }
        case 167: break;
        case 83: 
          { return symbol(LexerSymbols.GETINTERPOLANTS, yytext());
          }
        case 168: break;
        case 14: 
          { return symbol(LexerSymbols.KEYWORD, yytext());
          }
        case 169: break;
        case 66: 
          { return symbol(LexerSymbols.DEFINEFUN, yytext());
          }
        case 170: break;
        case 2: 
          { /* ignore */
          }
        case 171: break;
        case 87: 
          { return symbol(LexerSymbols.CSORTSDESCRIPTION, yytext());
          }
        case 172: break;
        case 82: 
          { return symbol(LexerSymbols.CPRODUCEPROOFS, yytext());
          }
        case 173: break;
        case 11: 
          { yybegin(YYINITIAL); 
                                   return symbol(LexerSymbols.STRING, 
                                   string.toString());
          }
        case 174: break;
        case 4: 
          { return symbol(LexerSymbols.NUMERAL, convertNumeral(yytext()));
          }
        case 175: break;
        case 33: 
          { return symbol(LexerSymbols.UNSAT, yytext());
          }
        case 176: break;
        case 46: 
          { return symbol(LexerSymbols.SUCCESS, yytext());
          }
        case 177: break;
        case 88: 
          { return symbol(LexerSymbols.CEXPANDDEFINITIONS, yytext());
          }
        case 178: break;
        case 10: 
          { string.append( yytext() );
          }
        case 179: break;
        case 3: 
          { return symbol(LexerSymbols.SYMBOL, yytext());
          }
        case 180: break;
        case 21: 
          { return symbol(LexerSymbols.LET, yytext());
          }
        case 181: break;
        case 67: 
          { return symbol(LexerSymbols.GETOPTION, yytext());
          }
        case 182: break;
        case 56: 
          { return symbol(LexerSymbols.CTHEORIES, yytext());
          }
        case 183: break;
        case 7: 
          { return symbol(LexerSymbols.UNDERSCORE, yytext());
          }
        case 184: break;
        case 94: 
          { return symbol(LexerSymbols.CDIAGNOSTICOUTPUTCHANNEL, yytext());
          }
        case 185: break;
        case 18: 
          { return symbol(LexerSymbols.HEXADECIMAL, yytext());
          }
        case 186: break;
        case 78: 
          { return symbol(LexerSymbols.GETASSERTIONS, yytext());
          }
        case 187: break;
        case 43: 
          { return symbol(LexerSymbols.MEMOUT, yytext());
          }
        case 188: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              {
                return symbol(LexerSymbols.EOF);
              }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
