/*
 * Decompiled with CFR 0.152.
 */
package java_cup.runtime;

final class TableDecoder {
    private String[] coded_tables;
    private int array_idx;
    private int string_idx;

    public TableDecoder(String[] tables) {
        this.coded_tables = tables;
        this.string_idx = 0;
        this.array_idx = 0;
    }

    private char advance() {
        if (this.string_idx == this.coded_tables[this.array_idx].length()) {
            this.string_idx = 0;
            ++this.array_idx;
        }
        return this.coded_tables[this.array_idx].charAt(this.string_idx++);
    }

    public short decodeShort() {
        return (short)this.advance();
    }

    public int decodeInt() {
        int val = this.advance();
        if (val >= 32768) {
            val = ((val & Short.MAX_VALUE) << 16) + this.advance();
        }
        return val;
    }

    public int[] decodeIntArray() {
        int size = this.decodeInt();
        int[] arr = new int[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = this.decodeInt();
        }
        return arr;
    }

    public short[] decodeShortArray() {
        int size = this.decodeInt();
        short[] arr = new short[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = this.decodeShort();
        }
        return arr;
    }
}

