/*
 * Decompiled with CFR 0.152.
 */
package java_cup;

import java.util.BitSet;
import java.util.TreeSet;
import java_cup.CombRow;
import java_cup.Grammar;

public class parse_action_table {
    public final int[][] table;
    public static final int ERROR = 0;
    public static final int SHIFT = 1;
    public static final int REDUCE = 2;

    public parse_action_table(Grammar grammar) {
        int _num_states = grammar.lalr_states().size();
        int _num_terminals = grammar.num_terminals();
        this.table = new int[_num_states][_num_terminals + 1];
    }

    public static int action(int kind, int index) {
        return 2 * index + kind;
    }

    public static boolean isReduce(int code) {
        return code != 0 && (code & 1) == 0;
    }

    public static boolean isShift(int code) {
        return (code & 1) != 0;
    }

    public static int index(int code) {
        return code - 1 >> 1;
    }

    public static String toString(int code) {
        if (code == 0) {
            return "ERROR";
        }
        if (parse_action_table.isShift(code)) {
            return "SHIFT(" + parse_action_table.index(code) + ")";
        }
        return "REDUCE(" + parse_action_table.index(code) + ")";
    }

    public short[] compress(int[] base_table) {
        int i;
        int[] default_actions = new int[this.table.length];
        TreeSet<CombRow> rows = new TreeSet<CombRow>();
        for (int i2 = 0; i2 < this.table.length; ++i2) {
            int[] row = this.table[i2];
            default_actions[i2] = row[row.length - 1];
            int len = 0;
            for (int j = 0; j < row.length - 1; ++j) {
                if (row[j] == default_actions[i2]) continue;
                ++len;
            }
            if (len == 0) continue;
            int[] comb = new int[len];
            len = 0;
            for (int j = 0; j < row.length - 1; ++j) {
                if (row[j] == default_actions[i2]) continue;
                comb[len++] = j;
            }
            rows.add(new CombRow(i2, comb));
        }
        BitSet used = new BitSet();
        int combsize = 0;
        for (CombRow row : rows) {
            row.fitInComb(used);
            int lastidx = row.base + this.table[row.index].length;
            if (lastidx <= combsize) continue;
            combsize = lastidx;
        }
        int _num_states = this.table.length;
        short[] compressed = new short[_num_states + 2 * combsize];
        for (i = 0; i < _num_states; ++i) {
            base_table[i] = (short)_num_states;
            compressed[i] = (short)default_actions[i];
        }
        for (i = 0; i < combsize; ++i) {
            compressed[_num_states + 2 * i] = (short)_num_states;
            compressed[_num_states + 2 * i + 1] = 1;
        }
        for (CombRow row : rows) {
            int base;
            base_table[row.index] = base = this.table.length + 2 * row.base;
            for (int j = 0; j < row.comb.length; ++j) {
                int t = row.comb[j];
                compressed[base + 2 * t] = (short)row.index;
                compressed[base + 2 * t + 1] = (short)this.table[row.index][t];
            }
        }
        return compressed;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("-------- ACTION_TABLE --------\n");
        for (int row = 0; row < this.table.length; ++row) {
            result.append("From state #").append(row).append("\n");
            int cnt = 0;
            int default_act = this.table[row][this.table[row].length - 1];
            result.append(" [default:").append(parse_action_table.toString(default_act)).append("]\n");
            for (int col = 0; col < this.table[row].length; ++col) {
                if (this.table[row][col] == default_act) continue;
                result.append(" [term ").append(col).append(":").append(parse_action_table.toString(this.table[row][col])).append("]");
                if (++cnt != 2) continue;
                result.append("\n");
                cnt = 0;
            }
            if (cnt == 0) continue;
            result.append("\n");
        }
        result.append("------------------------------");
        return result.toString();
    }
}

